/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.getevalrunoutputitems;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetEvalRunOutputItemsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Eval Id", description="The ID of the evaluation to retrieve runs for.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String evalId = null;
    @Widget(title="Run Id", description="The ID of the run to retrieve output items for.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String runId = null;
    @Widget(title="Set After", description="Enable to set the optional field <b>After</b>")
    @ValueReference(value=AfterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean afterEnabled = false;
    @Widget(title="After", description="Identifier for the last output item from the previous pagination request.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AfterEnabledRef.class, type=Effect.EffectType.SHOW)
    String after = null;
    @Widget(title="Set Limit", description="Enable to set the optional field <b>Limit</b>")
    @ValueReference(value=LimitEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean limitEnabled = false;
    @Widget(title="Limit", description="Number of output items to retrieve.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LimitEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int limit = 20;
    @Widget(title="Set Status", description="Enable to set the optional field <b>Status</b>")
    @ValueReference(value=StatusEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean statusEnabled = false;
    @Widget(title="Status", description="\tFilter output items by status. Use <tt>failed</tt> to filter by failed output\nitems or <tt>pass</tt> to filter by passed output items.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=StatusEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=StatusChoicesProvider.class)
    String status = STATUS_VALUES[0];
    private static final String[] STATUS_VALUES = new String[]{"fail", "pass"};
    @Widget(title="Set Order", description="Enable to set the optional field <b>Order</b>")
    @ValueReference(value=OrderEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean orderEnabled = false;
    @Widget(title="Order", description="Sort order for output items by timestamp. Use <tt>asc</tt> for ascending order or <tt>desc</tt> for descending order. Defaults to <tt>asc</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OrderEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=OrderChoicesProvider.class)
    String order = "asc";
    private static final String[] ORDER_VALUES = new String[]{"asc", "desc"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Object:</b> The type of this object. It is always set to &quot;list&quot;.</li>\n\t<li><b>Data:</b> An array of eval run output item objects.</li>\n\t<li><b>First Id:</b> The identifier of the first eval run output item in the data array.</li>\n\t<li><b>Last Id:</b> The identifier of the last eval run output item in the data array.</li>\n\t<li><b>Has More:</b> Indicates whether there are more eval run output items available.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetEvalRunOutputItemsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"object\":\"rows[0][0]\",\"data\":\"rows[0][1]\",\"first_id\":\"rows[0][2]\",\"last_id\":\"rows[0][3]\",\"has_more\":\"rows[0][4]\"}}]").addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has More", BooleanCell.BooleanCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetEvalRunOutputItemsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.evalId == null || this.evalId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cEval Id\u201d is required.");
        }
        if (this.runId == null || this.runId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRun Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("eval_id", this.evalId));
        params.add(new HttpRequestNodeParameters.Param("run_id", this.runId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.afterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("after", this.after));
        }
        if (this.limitEnabled) {
            params.add(new HttpRequestNodeParameters.Param("limit", this.limit));
        }
        if (this.statusEnabled) {
            params.add(new HttpRequestNodeParameters.Param("status", this.status));
        }
        if (this.orderEnabled) {
            params.add(new HttpRequestNodeParameters.Param("order", this.order));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class AfterEnabledRef
    implements BooleanReference {
        private AfterEnabledRef() {
        }
    }

    private static final class GetEvalRunOutputItemsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetEvalRunOutputItemsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class LimitEnabledRef
    implements BooleanReference {
        private LimitEnabledRef() {
        }
    }

    private static final class OrderChoicesProvider
    implements StringChoicesProvider {
        private OrderChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(ORDER_VALUES);
        }
    }

    private static final class OrderEnabledRef
    implements BooleanReference {
        private OrderEnabledRef() {
        }
    }

    private static final class StatusChoicesProvider
    implements StringChoicesProvider {
        private StatusChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(STATUS_VALUES);
        }
    }

    private static final class StatusEnabledRef
    implements BooleanReference {
        private StatusEnabledRef() {
        }
    }
}

