/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.getrunstep;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetRunStepNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="OpenAI Beta", description="Calls to the Assistants API require that you pass a beta HTTP header.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Open_AI_BetaChoicesProvider.class)
    String openAIBeta = OPEN_AI_BETA_VALUES[0];
    private static final String[] OPEN_AI_BETA_VALUES = new String[]{"assistants=v2"};
    @Widget(title="Thread Id", description="The ID of the thread to which the run and run step belongs.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String threadId = null;
    @Widget(title="Run Id", description="The ID of the run to which the run step belongs.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String runId = null;
    @Widget(title="Step Id", description="The ID of the run step to retrieve.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String stepId = null;
    @Widget(title="Set Include[]", description="Enable to set the optional field <b>Include[]</b>")
    @ValueReference(value=IncludeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeEnabled = false;
    @Widget(title="Include[]", description="\t<p>A list of additional fields to include in the response. Currently the only supported value is <tt>step_details.tool_calls[*].file_search.results[*].content</tt> to fetch the file search result content.</p>\n<p>See the <a href=\"https://platform.openai.com/docs/assistants/tools/file-search#customizing-file-search-settings\">file search tool documentation</a> for more information.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=IncludePersistor.class)
    Include[] include = new Include[]{new Include(INCLUDE_VALUES[0])};
    private static final String[] INCLUDE_VALUES = new String[]{"step_details.tool_calls[*].file_search.results[*].content"};
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Id:</b> The identifier of the run step, which can be referenced in API endpoints.</li>\n\t\t<li><b>Object:</b> The object type, which is always <tt>thread.run.step</tt>.</li>\n\t\t<li><b>Created At:</b> The Unix timestamp (in seconds) for when the run step was created.</li>\n\t\t<li><b>Assistant Id:</b> The ID of the <a href=\"https://platform.openai.com/docs/api-reference/assistants\">assistant</a> associated with the run step.</li>\n\t\t<li><b>Thread Id:</b> The ID of the <a href=\"https://platform.openai.com/docs/api-reference/threads\">thread</a> that was run.</li>\n\t\t<li><b>Run Id:</b> The ID of the <a href=\"https://platform.openai.com/docs/api-reference/runs\">run</a> that this run step is a part of.</li>\n\t\t<li><b>Type:</b> The type of run step, which can be either <tt>message_creation</tt> or <tt>tool_calls</tt>.</li>\n\t\t<li><b>Status:</b> The status of the run step, which can be either <tt>in_progress</tt>, <tt>cancelled</tt>, <tt>failed</tt>, <tt>completed</tt>, or <tt>expired</tt>.</li>\n\t\t<li><b>Step Details:</b> The details of the run step.</li>\n\t\t<li><b>Last Error:</b> The last error associated with this run step. Will be <tt>null</tt> if there are no errors.</li>\n\t\t<li><b>Expired At:</b> The Unix timestamp (in seconds) for when the run step expired. A step is considered expired if the parent run is expired.</li>\n\t\t<li><b>Cancelled At:</b> The Unix timestamp (in seconds) for when the run step was cancelled.</li>\n\t\t<li><b>Failed At:</b> The Unix timestamp (in seconds) for when the run step failed.</li>\n\t\t<li><b>Completed At:</b> The Unix timestamp (in seconds) for when the run step completed.</li>\n\t\t<li><b>Metadata:</b> <p>Set of 16 key-value pairs that can be attached to an object. This can be\nuseful for storing additional information about the object in a structured\nformat, and querying for objects via API or the dashboard.</p>\n<p>Keys are strings with a maximum length of 64 characters. Values are strings\nwith a maximum length of 512 characters.</p></li>\n\t\t<li><b>Usage:</b> Usage statistics related to the run step. This value will be <tt>null</tt> while the run step's status is <tt>in_progress</tt>.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetRunStepNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"object\":\"rows[0][1]\",\"created_at\":\"rows[0][2]\",\"assistant_id\":\"rows[0][3]\",\"thread_id\":\"rows[0][4]\",\"run_id\":\"rows[0][5]\",\"type\":\"rows[0][6]\",\"status\":\"rows[0][7]\",\"step_details\":\"rows[0][8]\",\"last_error\":\"rows[0][9]\",\"expired_at\":\"rows[0][10]\",\"cancelled_at\":\"rows[0][11]\",\"failed_at\":\"rows[0][12]\",\"completed_at\":\"rows[0][13]\",\"metadata\":\"rows[0][14]\",\"usage\":\"rows[0][15]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Assistant Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Thread Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Run Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Step Details", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Error", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Expired At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cancelled At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Failed At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Completed At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Metadata", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Usage", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetRunStepNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.openAIBeta == null || this.openAIBeta.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOpenAI Beta\u201d is required.");
        }
        if (this.threadId == null || this.threadId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cThread Id\u201d is required.");
        }
        if (this.runId == null || this.runId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRun Id\u201d is required.");
        }
        if (this.stepId == null || this.stepId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cStep Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("thread_id", this.threadId));
        params.add(new HttpRequestNodeParameters.Param("run_id", this.runId));
        params.add(new HttpRequestNodeParameters.Param("step_id", this.stepId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.includeEnabled) {
            Arrays.stream(this.include).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("include[]", value.text));
            });
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("OpenAI-Beta", this.openAIBeta));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetRunStepNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetRunStepNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Include
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=IncludeChoicesProvider.class)
        String text;

        Include() {
        }

        Include(String text) {
            this.text = text;
        }

        private static final class IncludeChoicesProvider
        implements StringChoicesProvider {
            private IncludeChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(INCLUDE_VALUES);
            }
        }
    }

    private static final class IncludeEnabledRef
    implements BooleanReference {
        private IncludeEnabledRef() {
        }
    }

    private static final class IncludePersistor
    implements NodeParametersPersistor<Include[]> {
        static final String CONFIG_KEY = "include";

        private IncludePersistor() {
        }

        public Include[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Include[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Include::new).toArray(Include[]::new);
        }

        public void save(Include[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class Open_AI_BetaChoicesProvider
    implements StringChoicesProvider {
        private Open_AI_BetaChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OPEN_AI_BETA_VALUES);
        }
    }
}

