/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.listassistants;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class ListAssistantsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="OpenAI Beta", description="Calls to the Assistants API require that you pass a beta HTTP header.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Open_AI_BetaChoicesProvider.class)
    String openAIBeta = OPEN_AI_BETA_VALUES[0];
    private static final String[] OPEN_AI_BETA_VALUES = new String[]{"assistants=v2"};
    @Widget(title="Set Limit", description="Enable to set the optional field <b>Limit</b>")
    @ValueReference(value=LimitEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean limitEnabled = false;
    @Widget(title="Limit", description="A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LimitEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int limit = 20;
    @Widget(title="Set Order", description="Enable to set the optional field <b>Order</b>")
    @ValueReference(value=OrderEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean orderEnabled = false;
    @Widget(title="Order", description="Sort order by the <tt>created_at</tt> timestamp of the objects. <tt>asc</tt> for ascending order and <tt>desc</tt> for descending order.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OrderEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=OrderChoicesProvider.class)
    String order = "desc";
    private static final String[] ORDER_VALUES = new String[]{"asc", "desc"};
    @Widget(title="Set After", description="Enable to set the optional field <b>After</b>")
    @ValueReference(value=AfterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean afterEnabled = false;
    @Widget(title="After", description="A cursor for use in pagination. <tt>after</tt> is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AfterEnabledRef.class, type=Effect.EffectType.SHOW)
    String after = null;
    @Widget(title="Set Before", description="Enable to set the optional field <b>Before</b>")
    @ValueReference(value=BeforeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean beforeEnabled = false;
    @Widget(title="Before", description="A cursor for use in pagination. <tt>before</tt> is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, starting with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BeforeEnabledRef.class, type=Effect.EffectType.SHOW)
    String before = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Object:</b> </li>\n\t<li><b>Data:</b> </li>\n\t<li><b>First Id:</b> </li>\n\t<li><b>Last Id:</b> </li>\n\t<li><b>Has More:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ListAssistantsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"object\":\"rows[0][0]\",\"data\":\"rows[0][1]\",\"first_id\":\"rows[0][2]\",\"last_id\":\"rows[0][3]\",\"has_more\":\"rows[0][4]\"}}]").addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has More", BooleanCell.BooleanCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    ListAssistantsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.openAIBeta == null || this.openAIBeta.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOpenAI Beta\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.limitEnabled) {
            params.add(new HttpRequestNodeParameters.Param("limit", this.limit));
        }
        if (this.orderEnabled) {
            params.add(new HttpRequestNodeParameters.Param("order", this.order));
        }
        if (this.afterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("after", this.after));
        }
        if (this.beforeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("before", this.before));
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("OpenAI-Beta", this.openAIBeta));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class AfterEnabledRef
    implements BooleanReference {
        private AfterEnabledRef() {
        }
    }

    private static final class BeforeEnabledRef
    implements BooleanReference {
        private BeforeEnabledRef() {
        }
    }

    private static final class LimitEnabledRef
    implements BooleanReference {
        private LimitEnabledRef() {
        }
    }

    private static final class ListAssistantsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ListAssistantsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Open_AI_BetaChoicesProvider
    implements StringChoicesProvider {
        private Open_AI_BetaChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OPEN_AI_BETA_VALUES);
        }
    }

    private static final class OrderChoicesProvider
    implements StringChoicesProvider {
        private OrderChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(ORDER_VALUES);
        }
    }

    private static final class OrderEnabledRef
    implements BooleanReference {
        private OrderEnabledRef() {
        }
    }
}

