/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.listauditlogs;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class ListAuditLogsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Effective At", description="Enable to set the optional field <b>Effective At</b>")
    @ValueReference(value=EffectiveAtEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean effectiveAtEnabled = false;
    @Widget(title="Effective At", description="Return only events whose <tt>effective_at</tt> (Unix seconds) is in this range.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=EffectiveAtEnabledRef.class, type=Effect.EffectType.SHOW)
    String effectiveAt = null;
    @Widget(title="Set Project Ids[]", description="Enable to set the optional field <b>Project Ids[]</b>")
    @ValueReference(value=ProjectIdsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean projectIdsEnabled = false;
    @Widget(title="Project Ids[]", description="Return only events for these projects.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ProjectIdsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Project_IdsPersistor.class)
    Project_Ids[] projectIds = new Project_Ids[]{new Project_Ids(null)};
    @Widget(title="Set Event Types[]", description="Enable to set the optional field <b>Event Types[]</b>")
    @ValueReference(value=EventTypesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean eventTypesEnabled = false;
    @Widget(title="Event Types[]", description="Return only events with a <tt>type</tt> in one of these values. For example, <tt>project.created</tt>. For all options, see the documentation for the <a href=\"https://platform.openai.com/docs/api-reference/audit-logs/object\">audit log object</a>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=EventTypesEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Event_TypesPersistor.class)
    Event_Types[] eventTypes = new Event_Types[]{new Event_Types(EVENT_TYPES_VALUES[0])};
    private static final String[] EVENT_TYPES_VALUES = new String[]{"api_key.created", "api_key.updated", "api_key.deleted", "checkpoint_permission.created", "checkpoint_permission.deleted", "invite.sent", "invite.accepted", "invite.deleted", "login.succeeded", "login.failed", "logout.succeeded", "logout.failed", "organization.updated", "project.created", "project.updated", "project.archived", "service_account.created", "service_account.updated", "service_account.deleted", "rate_limit.updated", "rate_limit.deleted", "user.added", "user.updated", "user.deleted"};
    @Widget(title="Set Actor Ids[]", description="Enable to set the optional field <b>Actor Ids[]</b>")
    @ValueReference(value=ActorIdsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean actorIdsEnabled = false;
    @Widget(title="Actor Ids[]", description="Return only events performed by these actors. Can be a user ID, a service account ID, or an api key tracking ID.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ActorIdsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Actor_IdsPersistor.class)
    Actor_Ids[] actorIds = new Actor_Ids[]{new Actor_Ids(null)};
    @Widget(title="Set Actor Emails[]", description="Enable to set the optional field <b>Actor Emails[]</b>")
    @ValueReference(value=ActorEmailsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean actorEmailsEnabled = false;
    @Widget(title="Actor Emails[]", description="Return only events performed by users with these emails.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ActorEmailsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Actor_EmailsPersistor.class)
    Actor_Emails[] actorEmails = new Actor_Emails[]{new Actor_Emails(null)};
    @Widget(title="Set Resource Ids[]", description="Enable to set the optional field <b>Resource Ids[]</b>")
    @ValueReference(value=ResourceIdsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean resourceIdsEnabled = false;
    @Widget(title="Resource Ids[]", description="Return only events performed on these targets. For example, a project ID updated.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ResourceIdsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Resource_IdsPersistor.class)
    Resource_Ids[] resourceIds = new Resource_Ids[]{new Resource_Ids(null)};
    @Widget(title="Set Limit", description="Enable to set the optional field <b>Limit</b>")
    @ValueReference(value=LimitEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean limitEnabled = false;
    @Widget(title="Limit", description="A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LimitEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int limit = 20;
    @Widget(title="Set After", description="Enable to set the optional field <b>After</b>")
    @ValueReference(value=AfterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean afterEnabled = false;
    @Widget(title="After", description="A cursor for use in pagination. <tt>after</tt> is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AfterEnabledRef.class, type=Effect.EffectType.SHOW)
    String after = null;
    @Widget(title="Set Before", description="Enable to set the optional field <b>Before</b>")
    @ValueReference(value=BeforeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean beforeEnabled = false;
    @Widget(title="Before", description="A cursor for use in pagination. <tt>before</tt> is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, starting with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BeforeEnabledRef.class, type=Effect.EffectType.SHOW)
    String before = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Object:</b> </li>\n\t<li><b>Data:</b> </li>\n\t<li><b>First Id:</b> </li>\n\t<li><b>Last Id:</b> </li>\n\t<li><b>Has More:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ListAuditLogsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"object\":\"rows[0][0]\",\"data\":\"rows[0][1]\",\"first_id\":\"rows[0][2]\",\"last_id\":\"rows[0][3]\",\"has_more\":\"rows[0][4]\"}}]").addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has More", BooleanCell.BooleanCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    ListAuditLogsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.effectiveAtEnabled) {
            params.add(new HttpRequestNodeParameters.Param("effective_at", this.effectiveAt));
        }
        if (this.projectIdsEnabled) {
            Arrays.stream(this.projectIds).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("project_ids[]", value.text));
            });
        }
        if (this.eventTypesEnabled) {
            Arrays.stream(this.eventTypes).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("event_types[]", value.text));
            });
        }
        if (this.actorIdsEnabled) {
            Arrays.stream(this.actorIds).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("actor_ids[]", value.text));
            });
        }
        if (this.actorEmailsEnabled) {
            Arrays.stream(this.actorEmails).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("actor_emails[]", value.text));
            });
        }
        if (this.resourceIdsEnabled) {
            Arrays.stream(this.resourceIds).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("resource_ids[]", value.text));
            });
        }
        if (this.limitEnabled) {
            params.add(new HttpRequestNodeParameters.Param("limit", this.limit));
        }
        if (this.afterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("after", this.after));
        }
        if (this.beforeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("before", this.before));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class ActorEmailsEnabledRef
    implements BooleanReference {
        private ActorEmailsEnabledRef() {
        }
    }

    private static final class ActorIdsEnabledRef
    implements BooleanReference {
        private ActorIdsEnabledRef() {
        }
    }

    static final class Actor_Emails
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Actor_Emails() {
        }

        Actor_Emails(String text) {
            this.text = text;
        }
    }

    private static final class Actor_EmailsPersistor
    implements NodeParametersPersistor<Actor_Emails[]> {
        static final String CONFIG_KEY = "actorEmails";

        private Actor_EmailsPersistor() {
        }

        public Actor_Emails[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Actor_Emails[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Actor_Emails::new).toArray(Actor_Emails[]::new);
        }

        public void save(Actor_Emails[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    static final class Actor_Ids
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Actor_Ids() {
        }

        Actor_Ids(String text) {
            this.text = text;
        }
    }

    private static final class Actor_IdsPersistor
    implements NodeParametersPersistor<Actor_Ids[]> {
        static final String CONFIG_KEY = "actorIds";

        private Actor_IdsPersistor() {
        }

        public Actor_Ids[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Actor_Ids[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Actor_Ids::new).toArray(Actor_Ids[]::new);
        }

        public void save(Actor_Ids[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class AfterEnabledRef
    implements BooleanReference {
        private AfterEnabledRef() {
        }
    }

    private static final class BeforeEnabledRef
    implements BooleanReference {
        private BeforeEnabledRef() {
        }
    }

    private static final class EffectiveAtEnabledRef
    implements BooleanReference {
        private EffectiveAtEnabledRef() {
        }
    }

    private static final class EventTypesEnabledRef
    implements BooleanReference {
        private EventTypesEnabledRef() {
        }
    }

    static final class Event_Types
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Event_TypesChoicesProvider.class)
        String text;

        Event_Types() {
        }

        Event_Types(String text) {
            this.text = text;
        }

        private static final class Event_TypesChoicesProvider
        implements StringChoicesProvider {
            private Event_TypesChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(EVENT_TYPES_VALUES);
            }
        }
    }

    private static final class Event_TypesPersistor
    implements NodeParametersPersistor<Event_Types[]> {
        static final String CONFIG_KEY = "eventTypes";

        private Event_TypesPersistor() {
        }

        public Event_Types[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Event_Types[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Event_Types::new).toArray(Event_Types[]::new);
        }

        public void save(Event_Types[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class LimitEnabledRef
    implements BooleanReference {
        private LimitEnabledRef() {
        }
    }

    private static final class ListAuditLogsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ListAuditLogsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ProjectIdsEnabledRef
    implements BooleanReference {
        private ProjectIdsEnabledRef() {
        }
    }

    static final class Project_Ids
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Project_Ids() {
        }

        Project_Ids(String text) {
            this.text = text;
        }
    }

    private static final class Project_IdsPersistor
    implements NodeParametersPersistor<Project_Ids[]> {
        static final String CONFIG_KEY = "projectIds";

        private Project_IdsPersistor() {
        }

        public Project_Ids[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Project_Ids[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Project_Ids::new).toArray(Project_Ids[]::new);
        }

        public void save(Project_Ids[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class ResourceIdsEnabledRef
    implements BooleanReference {
        private ResourceIdsEnabledRef() {
        }
    }

    static final class Resource_Ids
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Resource_Ids() {
        }

        Resource_Ids(String text) {
            this.text = text;
        }
    }

    private static final class Resource_IdsPersistor
    implements NodeParametersPersistor<Resource_Ids[]> {
        static final String CONFIG_KEY = "resourceIds";

        private Resource_IdsPersistor() {
        }

        public Resource_Ids[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Resource_Ids[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Resource_Ids::new).toArray(Resource_Ids[]::new);
        }

        public void save(Resource_Ids[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }
}

