/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openlegaldata.de.operation.courtsread;

import com.nodepit.nodes.openlegaldata.de.HttpRequestNodeParameters;
import com.nodepit.nodes.openlegaldata.de.NodeParametersUtils;
import com.nodepit.nodes.openlegaldata.de.ResponseMapper;
import com.nodepit.nodes.openlegaldata.de.SimpleResponseMapper;
import com.nodepit.nodes.openlegaldata.de.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class CourtsReadNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Id", description="A unique integer value identifying this court.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    int id = 0;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Id:</b> </li>\n\t<li><b>Name:</b> Full name of the court with location</li>\n\t<li><b>Court Type:</b> Court type AG,VG,...</li>\n\t<li><b>City:</b> Court belongs to this city, if null court is state-level</li>\n\t<li><b>State:</b> Court belongs to this state (derive country of this field)</li>\n\t<li><b>Code:</b> Unique court identifier based on ECLI (e.g. BVerfG)</li>\n\t<li><b>Slug:</b> Type &amp; city name as lowercase</li>\n\t<li><b>Description:</b> </li>\n\t<li><b>Image:</b> </li>\n\t<li><b>Homepage:</b> Official court homepage</li>\n\t<li><b>Street Address:</b> Street address with house number</li>\n\t<li><b>Postal Code:</b> Postal code (ZIP code)</li>\n\t<li><b>Address Locality:</b> Locality (city name)</li>\n\t<li><b>Telephone:</b> Telephone number</li>\n\t<li><b>Fax Number:</b> Fax number</li>\n\t<li><b>Jurisdiction:</b> Jurisdiction of court (ordinary, civil, ...)</li>\n\t<li><b>Level of Appeal:</b> Subject-matter jurisdiction (local, federal, high court, ...)</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CourtsReadNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"name\":\"rows[0][1]\",\"court_type\":\"rows[0][2]\",\"city\":\"rows[0][3]\",\"state\":\"rows[0][4]\",\"code\":\"rows[0][5]\",\"slug\":\"rows[0][6]\",\"description\":\"rows[0][7]\",\"image\":\"rows[0][8]\",\"homepage\":\"rows[0][9]\",\"street_address\":\"rows[0][10]\",\"postal_code\":\"rows[0][11]\",\"address_locality\":\"rows[0][12]\",\"telephone\":\"rows[0][13]\",\"fax_number\":\"rows[0][14]\",\"jurisdiction\":\"rows[0][15]\",\"level_of_appeal\":\"rows[0][16]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Court Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("City", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("State", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Code", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Slug", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Image", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Homepage", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Street Address", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Postal Code", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Address Locality", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Telephone", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Fax Number", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Jurisdiction", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Level of Appeal", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CourtsReadNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class CourtsReadNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CourtsReadNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

