/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openlegaldata.de.operation.stateslist;

import com.nodepit.nodes.openlegaldata.de.HttpRequestNodeParameters;
import com.nodepit.nodes.openlegaldata.de.NodeParametersUtils;
import com.nodepit.nodes.openlegaldata.de.ResponseMapper;
import com.nodepit.nodes.openlegaldata.de.SimpleResponseMapper;
import com.nodepit.nodes.openlegaldata.de.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class StatesListNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Limit", description="Enable to set the optional field <b>Limit</b>")
    @ValueReference(value=LimitEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean limitEnabled = false;
    @Widget(title="Limit", description="Number of results to return per page.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LimitEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int limit = 0;
    @Widget(title="Set Offset", description="Enable to set the optional field <b>Offset</b>")
    @ValueReference(value=OffsetEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean offsetEnabled = false;
    @Widget(title="Offset", description="The initial index from which to return the results.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OffsetEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int offset = 0;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Count:</b> </li>\n\t<li><b>Next:</b> </li>\n\t<li><b>Previous:</b> </li>\n\t<li><b>Results:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=StatesListNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"count\":\"rows[0][0]\",\"next\":\"rows[0][1]\",\"previous\":\"rows[0][2]\",\"results\":\"rows[0][3]\"}}]").addBodyColumn(new DataColumnSpecCreator("Count", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Next", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Previous", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Results", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    StatesListNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.limitEnabled) {
            params.add(new HttpRequestNodeParameters.Param("limit", this.limit));
        }
        if (this.offsetEnabled) {
            params.add(new HttpRequestNodeParameters.Param("offset", this.offset));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class LimitEnabledRef
    implements BooleanReference {
        private LimitEnabledRef() {
        }
    }

    private static final class OffsetEnabledRef
    implements BooleanReference {
        private OffsetEnabledRef() {
        }
    }

    private static final class StatesListNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private StatesListNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

