/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openlegaldata.de.auth.apikey;

import com.nodepit.nodes.openlegaldata.de.InterceptorFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ApiKeyInterceptorFactory
extends InterceptorFactory<ApiKeyAuthData> {
    public static final String IDENTIFIER = "api_key";
    private static final String API_KEY_PREFIX = null;

    public ApiKeyInterceptorFactory() {
        super(IDENTIFIER, ApiKeyAuthData.class);
    }

    @Override
    protected Interceptor createInterceptor(final ApiKeyAuthData data) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                Object apikey = data.apiKey;
                if (API_KEY_PREFIX != null) {
                    apikey = API_KEY_PREFIX + " " + (String)apikey;
                }
                Request authRequest = originalRequest.newBuilder().header("Authorization", (String)apikey).build();
                return chain.proceed(authRequest);
            }
        };
    }

    public static final class ApiKeyAuthData {
        String apiKey;
    }
}

