/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openlegaldata.de.operation.casescreate;

import com.nodepit.nodes.openlegaldata.de.HttpRequestNodeParameters;
import com.nodepit.nodes.openlegaldata.de.NodeParametersUtils;
import com.nodepit.nodes.openlegaldata.de.ResponseMapper;
import com.nodepit.nodes.openlegaldata.de.SimpleResponseMapper;
import com.nodepit.nodes.openlegaldata.de.TransformToTableMapper;
import com.nodepit.nodes.openlegaldata.de.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;

class CasesCreateNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Body", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CasesCreateNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Id:</b> </li>\n\t<li><b>Slug:</b> </li>\n\t<li><b>Court:</b> </li>\n\t<li><b>File Number:</b> File number as defined by court</li>\n\t<li><b>Date:</b> Publication date as in source</li>\n\t<li><b>Created Date:</b> Entry is created at this date time</li>\n\t<li><b>Updated Date:</b> Date time of last change</li>\n\t<li><b>Type:</b> Type of decision (Urteil, Beschluss, ...)</li>\n\t<li><b>Ecli:</b> European Case Law Identifier</li>\n\t<li><b>Content:</b> Case full-text formatted in Legal HTML</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CasesCreateNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"slug\":\"rows[0][1]\",\"court\":\"rows[0][2]\",\"file_number\":\"rows[0][3]\",\"date\":\"rows[0][4]\",\"created_date\":\"rows[0][5]\",\"updated_date\":\"rows[0][6]\",\"type\":\"rows[0][7]\",\"ecli\":\"rows[0][8]\",\"content\":\"rows[0][9]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Slug", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Court", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("File Number", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created Date", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated Date", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Ecli", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Content", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CasesCreateNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class CasesCreateNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CasesCreateNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

