/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openlegaldata.de.operation.casemarkersread;

import com.nodepit.nodes.openlegaldata.de.HttpRequestNodeParameters;
import com.nodepit.nodes.openlegaldata.de.NodeParametersUtils;
import com.nodepit.nodes.openlegaldata.de.ResponseMapper;
import com.nodepit.nodes.openlegaldata.de.SimpleResponseMapper;
import com.nodepit.nodes.openlegaldata.de.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class CaseMarkersReadNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Id", description="A unique integer value identifying this case marker.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    int id = 0;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Id:</b> </li>\n\t<li><b>Belongs To:</b> </li>\n\t<li><b>Label:</b> </li>\n\t<li><b>Value Str:</b> </li>\n\t<li><b>Value Int:</b> </li>\n\t<li><b>Created At:</b> Entry is created at this date time</li>\n\t<li><b>Updated At:</b> Date time of last change</li>\n\t<li><b>Start:</b> Start position of marker (from 0)</li>\n\t<li><b>End:</b> End position of marker</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CaseMarkersReadNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"belongs_to\":\"rows[0][1]\",\"label\":\"rows[0][2]\",\"value_str\":\"rows[0][3]\",\"value_int\":\"rows[0][4]\",\"created_at\":\"rows[0][5]\",\"updated_at\":\"rows[0][6]\",\"start\":\"rows[0][7]\",\"end\":\"rows[0][8]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Belongs To", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Label", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Value Str", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Value Int", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Start", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("End", LongCell.LongCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CaseMarkersReadNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class CaseMarkersReadNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CaseMarkersReadNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

