/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openlegaldata.de.operation.lawssearchlist;

import com.nodepit.nodes.openlegaldata.de.HttpRequestNodeParameters;
import com.nodepit.nodes.openlegaldata.de.NodeParametersUtils;
import com.nodepit.nodes.openlegaldata.de.ResponseMapper;
import com.nodepit.nodes.openlegaldata.de.SimpleResponseMapper;
import com.nodepit.nodes.openlegaldata.de.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class LawsSearchListNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Page", description="Enable to set the optional field <b>Page</b>")
    @ValueReference(value=PageEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageEnabled = false;
    @Widget(title="Page", description="A page number within the paginated result set.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int page = 0;
    @Widget(title="Set Page Size", description="Enable to set the optional field <b>Page Size</b>")
    @ValueReference(value=PageSizeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageSizeEnabled = false;
    @Widget(title="Page Size", description="Number of results to return per page.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageSizeEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int pageSize = 0;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Count:</b> </li>\n\t<li><b>Next:</b> </li>\n\t<li><b>Previous:</b> </li>\n\t<li><b>Results:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=LawsSearchListNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"count\":\"rows[0][0]\",\"next\":\"rows[0][1]\",\"previous\":\"rows[0][2]\",\"results\":\"rows[0][3]\"}}]").addBodyColumn(new DataColumnSpecCreator("Count", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Next", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Previous", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Results", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    LawsSearchListNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.pageEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page", this.page));
        }
        if (this.pageSizeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page_size", this.pageSize));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class LawsSearchListNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private LawsSearchListNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class PageEnabledRef
    implements BooleanReference {
        private PageEnabledRef() {
        }
    }

    private static final class PageSizeEnabledRef
    implements BooleanReference {
        private PageSizeEnabledRef() {
        }
    }
}

