/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.cloud.azure.storage.httpheaders;

import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.TimeoutPolicy;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.regex.Pattern;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.credentials.base.Credential;
import org.knime.credentials.base.CredentialPortObject;
import org.knime.credentials.base.oauth.api.JWTCredential;
import org.knime.ext.azure.AzureUtils;
import org.knime.ext.azure.TokenCredentialFactory;
import org.knime.ext.microsoft.authentication.credential.AzureStorageSasUrlCredential;
import org.knime.ext.microsoft.authentication.credential.AzureStorageSharedKeyCredential;
import ws.palladian.nodes.cloud.azure.storage.httpheaders.AzureStorageHttpHeadersNodeSettings;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class AzureStorageHttpHeadersNodeModel
extends NodeModel {
    private final AzureStorageHttpHeadersNodeSettings nodeSettings = new AzureStorageHttpHeadersNodeSettings();

    protected AzureStorageHttpHeadersNodeModel() {
        super(new PortType[]{CredentialPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE});
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{AzureStorageHttpHeadersNodeModel.createSpec()};
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        CredentialPortObject portObject = (CredentialPortObject)inObjects[0];
        Credential credential = (Credential)portObject.getCredential(Credential.class).get();
        BlobServiceClient blobServiceClient = AzureStorageHttpHeadersNodeModel.createServiceClient(credential);
        BlobContainerClient blobContainerClient = blobServiceClient.getBlobContainerClient(this.nodeSettings.blobContainerName.getStringValue());
        Pattern pattern = Pattern.compile(this.nodeSettings.fileNamePattern.getStringValue());
        PagedIterable blobs = blobContainerClient.listBlobs();
        BufferedDataContainer outputContainer = exec.createDataContainer(AzureStorageHttpHeadersNodeModel.createSpec());
        long rowCount = 0L;
        for (BlobItem blob : blobs) {
            String blobName = blob.getName();
            BlobClient blobClient = blobContainerClient.getBlobClient(blobName);
            exec.setProgress("Processing " + blobName);
            BlobProperties properties = blobClient.getProperties();
            if (pattern.matcher(blobName).matches()) {
                BlobHttpHeaders headers = new BlobHttpHeaders();
                boolean modified = false;
                modified |= this.nodeSettings.contentLanguage.applySetting(properties.getContentLanguage(), arg_0 -> ((BlobHttpHeaders)headers).setContentLanguage(arg_0));
                modified |= this.nodeSettings.contentType.applySetting(properties.getContentType(), arg_0 -> ((BlobHttpHeaders)headers).setContentType(arg_0));
                modified |= this.nodeSettings.cacheControl.applySetting(properties.getCacheControl(), arg_0 -> ((BlobHttpHeaders)headers).setCacheControl(arg_0));
                modified |= this.nodeSettings.contentDisposition.applySetting(properties.getContentDisposition(), arg_0 -> ((BlobHttpHeaders)headers).setContentDisposition(arg_0));
                headers.setContentMd5(properties.getContentMd5());
                if (modified |= this.nodeSettings.contentEncoding.applySetting(properties.getContentEncoding(), arg_0 -> ((BlobHttpHeaders)headers).setContentEncoding(arg_0))) {
                    blobClient.setHttpHeaders(headers);
                }
                outputContainer.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)rowCount), new DataCell[]{new StringCell(blobName), PalladianKnimeHelper.createStringCell((String)headers.getContentLanguage()), PalladianKnimeHelper.createStringCell((String)headers.getContentType()), PalladianKnimeHelper.createStringCell((String)headers.getCacheControl()), PalladianKnimeHelper.createStringCell((String)headers.getContentDisposition()), PalladianKnimeHelper.createStringCell((String)headers.getContentEncoding()), BooleanCell.BooleanCellFactory.create((boolean)modified)}));
            }
            ++rowCount;
        }
        outputContainer.close();
        return new PortObject[]{outputContainer.getTable()};
    }

    private static DataTableSpec createSpec() {
        return new DataTableSpecCreator().addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Blob Name", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content-Language", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content-Type", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Cache-Control", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content-Disposition", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content-Encoding", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Modified", BooleanCell.TYPE).createSpec()}).createSpec();
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }

    protected void reset() {
    }

    private static BlobServiceClient createServiceClient(Credential credential) throws IOException {
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder().endpoint(AzureUtils.getEndpoint((Credential)credential)).addPolicy((HttpPipelinePolicy)new TimeoutPolicy(Duration.ofSeconds(30L)));
        if (credential instanceof AzureStorageSharedKeyCredential) {
            AzureStorageSharedKeyCredential sharedKeyCred = (AzureStorageSharedKeyCredential)credential;
            builder.credential(new StorageSharedKeyCredential(sharedKeyCred.getStorageAccountName(), sharedKeyCred.getSharedKey()));
        } else if (!(credential instanceof AzureStorageSasUrlCredential)) {
            if (credential instanceof JWTCredential) {
                JWTCredential jwtCredential = (JWTCredential)credential;
                builder.credential(TokenCredentialFactory.create((JWTCredential)jwtCredential));
            } else {
                throw new UnsupportedOperationException("Unsupported credential type " + String.valueOf(credential.getType()));
            }
        }
        if (AzureUtils.isProxyActive()) {
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setProxyOptions(AzureUtils.loadSystemProxyOptions());
            builder.clientOptions((ClientOptions)clientOptions);
        }
        return builder.buildClient();
    }
}

