/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.cloud.azure.storage.httpheaders;

import java.util.Objects;
import java.util.function.Consumer;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.NodeSettings;
import ws.palladian.nodes.StringUtils;

final class AzureStorageHttpHeadersNodeSettings
implements NodeSettings {
    final SettingsModelString blobContainerName = new SettingsModelString("blobContainerName", null);
    final SettingsModelString fileNamePattern = new SettingsModelString("fileNamePattern", ".*");
    final SettingsPair contentLanguage = new SettingsPair("contentLanguage");
    final SettingsPair contentType = new SettingsPair("contentType");
    final SettingsPair cacheControl = new SettingsPair("cacheControl");
    final SettingsPair contentDisposition = new SettingsPair("contentDisposition");
    final SettingsPair contentEncoding = new SettingsPair("contentEncoding");

    AzureStorageHttpHeadersNodeSettings() {
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        this.blobContainerName.saveSettingsTo(settings);
        this.fileNamePattern.saveSettingsTo(settings);
        this.contentLanguage.saveSettingsTo(settings);
        this.contentType.saveSettingsTo(settings);
        this.cacheControl.saveSettingsTo(settings);
        this.contentDisposition.saveSettingsTo(settings);
        this.contentEncoding.saveSettingsTo(settings);
    }

    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.blobContainerName.loadSettingsFrom(settings);
        this.fileNamePattern.loadSettingsFrom(settings);
        this.contentLanguage.loadValidatedSettingsFrom(settings);
        this.contentType.loadValidatedSettingsFrom(settings);
        this.cacheControl.loadValidatedSettingsFrom(settings);
        this.contentDisposition.loadValidatedSettingsFrom(settings);
        this.contentEncoding.loadValidatedSettingsFrom(settings);
    }

    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.blobContainerName.validateSettings(settings);
        this.fileNamePattern.validateSettings(settings);
        this.contentLanguage.validateSettings(settings);
        this.contentType.validateSettings(settings);
        this.cacheControl.validateSettings(settings);
        this.contentDisposition.validateSettings(settings);
        this.contentEncoding.validateSettings(settings);
    }

    static final class SettingsPair
    implements NodeSettings {
        final SettingsModelBoolean active;
        final SettingsModelString value;

        private SettingsPair(String name) {
            this.active = new SettingsModelBoolean("active_" + name, false);
            this.value = new SettingsModelString("value_" + name, null);
            this.active.addChangeListener(e -> this.value.setEnabled(this.active.getBooleanValue()));
        }

        public void saveSettingsTo(NodeSettingsWO settings) {
            this.active.saveSettingsTo(settings);
            this.value.saveSettingsTo(settings);
        }

        public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
            this.active.loadSettingsFrom(settings);
            this.value.loadSettingsFrom(settings);
        }

        public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
            this.active.validateSettings(settings);
            this.value.validateSettings(settings);
        }

        boolean applySetting(String currentValue, Consumer<String> headerSetter) {
            if (this.active.getBooleanValue()) {
                String newValue = StringUtils.emptyToNull((String)this.value.getStringValue());
                headerSetter.accept(newValue);
                return !Objects.equals(currentValue, newValue);
            }
            headerSetter.accept(currentValue);
            return false;
        }
    }
}

