/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.licensing.ui;

import com.nodepit.licensing.LicensableProduct;
import com.nodepit.licensing.LicenseInformation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class LicenseInputDialog
extends Dialog {
    private final LicensableProduct product;
    private Text licenseString;
    private Text errorMessageText;
    private String rawLicenseString;

    public LicenseInputDialog(LicensableProduct product, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.product = product;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText("Paste your license key");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)gridData);
        this.licenseString = new Text(composite, 2050);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.heightHint = 400;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.licenseString.setLayoutData((Object)gridData);
        this.licenseString.addModifyListener(e -> this.validateLicense());
        this.errorMessageText = new Text(composite, 72);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.errorMessageText.setLayoutData((Object)gridData);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        LicenseInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void validateLicense() {
        Button okButton = this.getButton(0);
        if (this.licenseString.getText().isEmpty()) {
            this.errorMessageText.setText("");
            okButton.setEnabled(false);
            return;
        }
        try {
            LicenseInformation license = this.product.parseLicense(this.licenseString.getText());
            this.errorMessageText.setText(license.toString());
            this.errorMessageText.setForeground(this.getShell().getDisplay().getSystemColor(6));
            okButton.setEnabled(true);
        }
        catch (Exception e) {
            this.errorMessageText.setText(e.getMessage());
            okButton.setEnabled(false);
            this.errorMessageText.setForeground(this.getShell().getDisplay().getSystemColor(3));
        }
    }

    protected void okPressed() {
        this.rawLicenseString = this.licenseString.getText();
        super.okPressed();
    }

    public String getRawLicenseString() {
        return this.rawLicenseString;
    }
}

