/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Request;
import org.knime.core.data.DataCell;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.workflow.FlowVariable;
import ws.palladian.nodes.oauth.OAuthNodeSettings;

public abstract class OAuthFlow {
    protected static final String CFGKEY_ACCESS_TOKEN = "accessToken";
    protected static final String CFGKEY_RAW_RESPONSE = "rawResponse";

    public abstract String getBrowserUrl() throws Exception;

    public abstract boolean validCallbackResponse(Request var1);

    @Deprecated
    public abstract void saveToken(Request var1, OAuthNodeSettings var2) throws Exception;

    public abstract OAuthData extractToken(Request var1) throws Exception;

    protected static Map<String, String> parseQueryParams(String queryString) {
        HashMap<String, String> params = new HashMap<String, String>();
        String[] stringArray = queryString.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            int idx = pair.indexOf("=");
            String key = OAuthFlow.decode(pair.substring(0, idx));
            String value = OAuthFlow.decode(pair.substring(idx + 1));
            params.put(key, value);
            ++n2;
        }
        return params;
    }

    private static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static interface OAuthData {
        public OAuthData refreshToken() throws Exception;

        public List<DataCell> getCells();

        public List<FlowVariable> getFlowVariables();

        public void saveSettings(NodeSettingsWO var1);

        public boolean needsRefresh();
    }
}

