/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth.custom;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.ServiceBuilderCommon;
import com.github.scribejava.core.builder.api.DefaultApi20;
import java.io.OutputStream;
import java.util.ArrayList;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettings;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.oauth.LogOutputStream;
import ws.palladian.nodes.oauth.OAuth20Flow;
import ws.palladian.nodes.oauth.OAuthFlow;
import ws.palladian.nodes.oauth.custom.CustomOAuthNodeDialog;

class CustomOAuthNodeSettings {
    static final String CFGKEY_PORT = "port";
    static final String CFGKEY_API_KEY = "apiKexy";
    static final String CFGKEY_API_SECRET = "apiSecret";
    static final String CFGKEY_AUTHORIZATION_URL = "authorizationUrl";
    static final String CFGKEY_TOKEN_URL = "tokenUrl";
    static final String CFGKEY_REFRESH_URL = "refreshUrl";
    static final String CFGKEY_SCOPE = "scope";
    static final NodeLogger LOGGER = NodeLogger.getLogger(CustomOAuthNodeSettings.class);
    final SettingsModelInteger port = new SettingsModelIntegerBounded("port", 55931, 0, 65535);
    final SettingsModelString apiKey = new SettingsModelString("apiKexy", null);
    final SettingsModelString apiSecret = new SettingsModelString("apiSecret", null);
    final SettingsModelString authorizationUrl = new SettingsModelString("authorizationUrl", null);
    final SettingsModelString tokenUrl = new SettingsModelString("tokenUrl", null);
    final SettingsModelString refreshUrl = new SettingsModelString("refreshUrl", null);
    final SettingsModelString scope = new SettingsModelString("scope", null);
    private static final String CFGKEY_TOKEN_DATA = "tokenData";
    private OAuthFlow.OAuthData oAuthToken;
    private final SettingsModel[] settings = new SettingsModel[]{this.port, this.apiKey, this.apiSecret, this.authorizationUrl, this.tokenUrl, this.refreshUrl, this.scope};
    final OAuth20Flow.OAuth20Api oauthApi = new OAuth20Flow.OAuth20Api(new DefaultApi20(){

        protected String getAuthorizationBaseUrl() {
            return CustomOAuthNodeSettings.this.authorizationUrl.getStringValue();
        }

        public String getAccessTokenEndpoint() {
            return CustomOAuthNodeSettings.this.tokenUrl.getStringValue();
        }

        public String getRefreshTokenEndpoint() {
            String refreshUrlValue = CustomOAuthNodeSettings.this.refreshUrl.getStringValue();
            if (StringUtils.nullOrEmpty((String)refreshUrlValue)) {
                return this.getAccessTokenEndpoint();
            }
            return refreshUrlValue;
        }
    });

    CustomOAuthNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        SettingsModel[] settingsModelArray = this.settings;
        int n = this.settings.length;
        int n2 = 0;
        while (n2 < n) {
            SettingsModel model = settingsModelArray[n2];
            model.saveSettingsTo(settings);
            ++n2;
        }
        if (this.oAuthToken != null) {
            this.oAuthToken.saveSettings(settings.addNodeSettings(CFGKEY_TOKEN_DATA));
        }
    }

    void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        SettingsModel[] settingsModelArray = this.settings;
        int n = this.settings.length;
        int n2 = 0;
        while (n2 < n) {
            SettingsModel model = settingsModelArray[n2];
            model.validateSettings(settings);
            ++n2;
        }
    }

    void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        SettingsModel[] settingsModelArray = this.settings;
        int n = this.settings.length;
        int n2 = 0;
        while (n2 < n) {
            SettingsModel model = settingsModelArray[n2];
            model.loadSettingsFrom(settings);
            ++n2;
        }
        try {
            NodeSettingsRO tokenData = settings.getNodeSettings(CFGKEY_TOKEN_DATA);
            this.oAuthToken = this.oauthApi.loadSettings(this.createServiceBuilder(), tokenData);
        }
        catch (InvalidSettingsException invalidSettingsException) {
            this.oAuthToken = null;
        }
    }

    void setOAuthToken(OAuthFlow.OAuthData oAuthToken) {
        this.oAuthToken = oAuthToken;
    }

    OAuthFlow.OAuthData getOAuthToken() {
        return this.oAuthToken;
    }

    OAuthFlow createFlow() {
        return this.oauthApi.createFlow(this.createServiceBuilder());
    }

    private ServiceBuilderCommon createServiceBuilder() {
        ServiceBuilder serviceBuilder = new ServiceBuilder(this.apiKey.getStringValue()).apiSecret(this.apiSecret.getStringValue()).callback("http://localhost:" + this.port.getIntValue()).debugStream((OutputStream)new LogOutputStream(LOGGER));
        if (StringUtils.notNullOrEmpty((String)this.scope.getStringValue())) {
            serviceBuilder = serviceBuilder.defaultScope(this.scope.getStringValue());
        }
        return serviceBuilder;
    }

    void validateSettingsForAuth() throws InvalidSettingsException {
        ArrayList<String> missingInput = new ArrayList<String>();
        if (StringUtils.nullOrEmpty((String)this.apiKey.getStringValue())) {
            missingInput.add("API Key");
        }
        if (StringUtils.nullOrEmpty((String)this.apiSecret.getStringValue())) {
            missingInput.add("API Secret");
        }
        if (StringUtils.nullOrEmpty((String)this.authorizationUrl.getStringValue())) {
            missingInput.add("Authorization URL");
        }
        if (StringUtils.nullOrEmpty((String)this.tokenUrl.getStringValue())) {
            missingInput.add("Token URL");
        }
        if (!missingInput.isEmpty()) {
            throw new InvalidSettingsException("The following input for authorizing is missing:\n" + String.join((CharSequence)", ", missingInput));
        }
    }

    CustomOAuthNodeSettings createForDialog(CustomOAuthNodeDialog dialog) {
        NodeSettings settingsTemp = new NodeSettings("temp");
        this.saveSettingsTo((NodeSettingsWO)settingsTemp);
        CustomOAuthNodeSettings copy = new CustomOAuthNodeSettings();
        try {
            copy.loadValidatedSettingsFrom((NodeSettingsRO)settingsTemp);
        }
        catch (InvalidSettingsException e) {
            throw new IllegalStateException("Could not copy the settings", e);
        }
        dialog.portFv.getVariableValue().ifPresent(value -> customOAuthNodeSettings.port.setIntValue(value.getIntValue()));
        dialog.apiKeyFv.getVariableValue().ifPresent(value -> customOAuthNodeSettings.apiKey.setStringValue(value.getStringValue()));
        dialog.apiSecretFv.getVariableValue().ifPresent(value -> customOAuthNodeSettings.apiSecret.setStringValue(value.getStringValue()));
        dialog.authUrlFv.getVariableValue().ifPresent(value -> customOAuthNodeSettings.authorizationUrl.setStringValue(value.getStringValue()));
        dialog.tokenUrlFv.getVariableValue().ifPresent(value -> customOAuthNodeSettings.tokenUrl.setStringValue(value.getStringValue()));
        dialog.refreshUrlFv.getVariableValue().ifPresent(value -> customOAuthNodeSettings.refreshUrl.setStringValue(value.getStringValue()));
        return copy;
    }
}

