/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.connector.db;

import java.io.File;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class GeoIP2DBConnectorNodeSettings {
    static final String KEY_DATABASE_FILE = "databaseFile";
    private final SettingsModelString databaseFile = new SettingsModelString("databaseFile", null);

    GeoIP2DBConnectorNodeSettings() {
    }

    public SettingsModelString getSettingDatabaseFile() {
        return this.databaseFile;
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        this.databaseFile.saveSettingsTo(settings);
    }

    public void loadSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.databaseFile.loadSettingsFrom(settings);
    }

    public void validateSettings() throws InvalidSettingsException {
        String pathToDBFile = this.getSettingDatabaseFile().getStringValue();
        if (StringUtils.nullOrEmpty((String)pathToDBFile)) {
            throw new InvalidSettingsException("Please specify an .mmdb database file.");
        }
        File dbFile = PalladianKnimeHelper.getFileFromUrlOrPath((String)this.getSettingDatabaseFile().getStringValue());
        if (!dbFile.isFile()) {
            throw new InvalidSettingsException("The file " + String.valueOf(dbFile) + " does not exist.");
        }
    }
}

