/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.connector.downloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Optional;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.maxmind.geoip2.connector.db.GeoIP2DBConnectorPortObjectSpec;
import ws.palladian.nodes.maxmind.geoip2.connector.downloader.GeoIP2DBDownloaderNodeSettings;
import ws.palladian.nodes.maxmind.geoip2.connector.port.GeoIP2ConnectorPortObject;

class GeoIP2DBDownloaderNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(GeoIP2DBDownloaderNodeModel.class);
    private static final String CACHE_DIR_NAME = ".palladianKnimeNodesMaxMindCache";
    private static final Path CACHE_DIR_PATH = Paths.get(System.getProperty("user.home"), ".palladianKnimeNodesMaxMindCache");
    private static final Path CACHE_MANIFEST_PATH = CACHE_DIR_PATH.resolve("cache-manifest.properties");
    private static final String CACHE_MANIFEST_COMMENT = "Cached versions of MaxMind DBs - do not modify.";
    private static final Object LOCK = new Object();
    private final GeoIP2DBDownloaderNodeSettings nodeSettings = new GeoIP2DBDownloaderNodeSettings();

    protected GeoIP2DBDownloaderNodeModel() {
        super(new PortType[0], new PortType[]{GeoIP2ConnectorPortObject.TYPE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        this.nodeSettings.validateSettings();
        Object object = LOCK;
        synchronized (object) {
            Files.createDirectories(CACHE_DIR_PATH, new FileAttribute[0]);
            Properties properties = new Properties();
            try {
                properties.load(Files.newInputStream(CACHE_MANIFEST_PATH, new OpenOption[0]));
            }
            catch (NoSuchFileException noSuchFileException) {
                LOGGER.debugWithFormat("%s does not exist", new Object[]{CACHE_MANIFEST_PATH});
            }
            GeoIP2DBDownloaderNodeSettings.DownloadableMaxMindDb dbInfo = GeoIP2DBDownloaderNodeSettings.DownloadableMaxMindDb.byLabel(this.nodeSettings.getSettingDb().getStringValue());
            Path mmdbFile = null;
            String cachedVersion = properties.getProperty(dbInfo.label);
            if (cachedVersion != null) {
                String filenameFromHeadRequest = GeoIP2DBDownloaderNodeModel.headRequestExtractFilename(URI.create(dbInfo.downloadUrl), this.nodeSettings.getSettingAccountID().getStringValue(), this.nodeSettings.getSettingLicenseKey().getStringValue());
                LOGGER.debugWithFormat("HEAD request returned %s", new Object[]{filenameFromHeadRequest});
                if (filenameFromHeadRequest.equals(cachedVersion)) {
                    Path cachedMmdbFile = CACHE_DIR_PATH.resolve("GeoLite2-" + dbInfo.label + ".mmdb");
                    if (Files.isRegularFile(cachedMmdbFile, new LinkOption[0])) {
                        mmdbFile = cachedMmdbFile;
                        LOGGER.infoWithFormat("DB unchanged: %s", new Object[]{filenameFromHeadRequest});
                    } else {
                        LOGGER.infoWithFormat("DB does not exist: %s", new Object[]{cachedMmdbFile});
                    }
                } else {
                    LOGGER.infoWithFormat("DB has changed: %s vs %s", new Object[]{filenameFromHeadRequest, cachedVersion});
                }
            }
            if (mmdbFile == null) {
                Path tempDownloadDir = Files.createTempDirectory("palladian-knime-maxmind-download", new FileAttribute[0]);
                LOGGER.infoWithFormat("Downloading %s", new Object[]{dbInfo.downloadUrl});
                ExecutionMonitor downloadProgress = exec.createSubProgress(0.5);
                String downloadedFileName = GeoIP2DBDownloaderNodeModel.downloadFile(URI.create(dbInfo.downloadUrl), tempDownloadDir, this.nodeSettings.getSettingAccountID().getStringValue(), this.nodeSettings.getSettingLicenseKey().getStringValue(), (read, total) -> downloadProgress.setProgress((double)read / (double)total, () -> "Downloading " + downloadableMaxMindDb.downloadUrl));
                LOGGER.debugWithFormat("Download of %s finished", new Object[]{downloadedFileName});
                ExecutionMonitor extractProgress = exec.createSubProgress(0.5);
                GeoIP2DBDownloaderNodeModel.extractTarGz(tempDownloadDir.resolve(downloadedFileName), tempDownloadDir, (extracted, total) -> extractProgress.setProgress((double)extracted / (double)total, () -> "Extracting " + downloadedFileName));
                LOGGER.debugWithFormat("Extracted to %s", new Object[]{tempDownloadDir});
                Path extractedDirectory = Files.list(tempDownloadDir).filter(path -> Files.isDirectory(path, new LinkOption[0])).findFirst().orElseThrow();
                LOGGER.debugWithFormat("Extracted directory: %s", new Object[]{extractedDirectory});
                Path extractedMmdbFile = Files.list(extractedDirectory).filter(f -> f.getFileName().toString().endsWith(".mmdb")).findFirst().orElseThrow();
                Path mmdbDestination = CACHE_DIR_PATH.resolve(extractedMmdbFile.getFileName());
                Files.move(extractedMmdbFile, mmdbDestination, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.debugWithFormat("Moved %s to %s", new Object[]{extractedMmdbFile, mmdbDestination});
                properties.setProperty(dbInfo.label, downloadedFileName);
                properties.store(Files.newOutputStream(CACHE_MANIFEST_PATH, new OpenOption[0]), CACHE_MANIFEST_COMMENT);
                mmdbFile = mmdbDestination;
            }
            LOGGER.debugWithFormat("Using %s", new Object[]{mmdbFile.toString()});
            return new PortObject[]{new GeoIP2ConnectorPortObject(new GeoIP2DBConnectorPortObjectSpec(mmdbFile.toString()))};
        }
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        this.nodeSettings.validateSettings();
        return new PortObjectSpec[1];
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        GeoIP2DBDownloaderNodeSettings temp = new GeoIP2DBDownloaderNodeSettings();
        temp.loadSettingsFrom(settings);
        try {
            temp.validateSettings();
        }
        catch (InvalidSettingsException e) {
            this.setWarningMessage(e.getMessage());
        }
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    private static String headRequestExtractFilename(URI fileURL, String username, String password) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
        HttpRequest request = HttpRequest.newBuilder().uri(fileURL).header("Authorization", "Basic " + GeoIP2DBDownloaderNodeModel.basicAuth(username, password)).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
        return GeoIP2DBDownloaderNodeModel.extractFileNameFromContentDisposition(response);
    }

    private static String basicAuth(String username, String password) {
        String auth = username + ":" + password;
        return Base64.getEncoder().encodeToString(auth.getBytes());
    }

    private static String extractFileNameFromContentDisposition(HttpResponse<?> response) throws IOException {
        String contentDisposition = response.headers().firstValue("Content-Disposition").orElseThrow(() -> new IOException("Expected Content-Disposition header"));
        return contentDisposition.substring(contentDisposition.indexOf("=") + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String downloadFile(URI fileURL, Path destinationPath, String username, String password, ProgressCallback callback) throws IOException, InterruptedException {
        HttpRequest request;
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
        HttpResponse<InputStream> response = client.send(request = HttpRequest.newBuilder().uri(fileURL).header("Authorization", "Basic " + GeoIP2DBDownloaderNodeModel.basicAuth(username, password)).GET().build(), HttpResponse.BodyHandlers.ofInputStream());
        if (response.statusCode() == 302) {
            Optional<String> locationHeader = response.headers().firstValue("Location");
            if (locationHeader.isEmpty()) {
                throw new IOException("Redirected, but no Location header found.");
            }
            URI redirectUri = URI.create(locationHeader.get());
            HttpRequest redirectedRequest = HttpRequest.newBuilder().uri(redirectUri).GET().build();
            response = client.send(redirectedRequest, HttpResponse.BodyHandlers.ofInputStream());
        }
        if (response.statusCode() != 200) {
            String errorBody = new String(response.body().readAllBytes(), StandardCharsets.UTF_8);
            throw new IOException("HTTP error code: " + response.statusCode() + "\nError body:\n" + errorBody);
        }
        String filename = GeoIP2DBDownloaderNodeModel.extractFileNameFromContentDisposition(response);
        long contentLength = response.headers().firstValueAsLong("Content-Length").orElse(-1L);
        Throwable throwable = null;
        Object var12_14 = null;
        try {
            InputStream inputStream = response.body();
            try {
                try (OutputStream outputStream = Files.newOutputStream(destinationPath.resolve(filename), new OpenOption[0]);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    long totalBytesRead = 0L;
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                        callback.onProgress(totalBytesRead += (long)bytesRead, contentLength);
                    }
                }
                if (inputStream == null) return filename;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return filename;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void extractTarGz(Path tarGzFile, Path outputDir, ProgressCallback callback) throws IOException {
        long totalSize = GeoIP2DBDownloaderNodeModel.calculateTotalSize(tarGzFile);
        Throwable throwable = null;
        Object var6_6 = null;
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GZIPInputStream(Files.newInputStream(tarGzFile, new OpenOption[0])));){
            TarArchiveEntry entry;
            long bytesExtracted = 0L;
            while ((entry = tarIn.getNextEntry()) != null) {
                Path entryPath = outputDir.resolve(entry.getName()).normalize();
                if (!entryPath.startsWith(outputDir)) {
                    throw new IOException("Blocked potential zip-slip attack: " + entry.getName());
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                Throwable throwable2 = null;
                Object var13_14 = null;
                try (OutputStream out = Files.newOutputStream(entryPath, new OpenOption[0]);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = tarIn.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                        callback.onProgress(bytesExtracted += (long)bytesRead, totalSize);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static long calculateTotalSize(Path tarGzFile) throws IOException {
        long totalSize = 0L;
        Throwable throwable = null;
        Object var4_4 = null;
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GZIPInputStream(Files.newInputStream(tarGzFile, new OpenOption[0])));){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextEntry()) != null) {
                totalSize += entry.getSize();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return totalSize;
    }

    static interface ProgressCallback {
        public void onProgress(long var1, long var3);
    }
}

