/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.extractor;

import java.util.List;
import java.util.stream.Collectors;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.port.PortObjectSpec;
import ws.palladian.nodes.maxmind.geoip2.connector.port.AbstractGeoIP2ConnectorPortObjectSpec;
import ws.palladian.nodes.maxmind.geoip2.connector.port.ResponseType;
import ws.palladian.nodes.maxmind.geoip2.extractor.GeoIP2ExtractorNodeSettings;

class GeoIP2ExtractorNodeDialog
extends DefaultNodeSettingsPane {
    private final GeoIP2ExtractorNodeSettings nodeSettings = new GeoIP2ExtractorNodeSettings();
    private final DialogComponentStringSelection responseSelection;

    protected GeoIP2ExtractorNodeDialog() {
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.nodeSettings.getSettingInputColumnName(), "Input", 1, new Class[]{StringValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.nodeSettings.getSettingOutputColumnPrefix(), "Output Column Prefix"));
        this.responseSelection = new DialogComponentStringSelection(this.nodeSettings.getSettingResponseType(), "Response Type", new String[]{"DUMMY"});
        this.addDialogComponent((DialogComponent)this.responseSelection);
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        AbstractGeoIP2ConnectorPortObjectSpec spec = (AbstractGeoIP2ConnectorPortObjectSpec)specs[0];
        if (spec == null) {
            throw new NotConfigurableException("Please connect the upper \u201cMaxMind Connector\u201d port before configuring the node and configure its source node.");
        }
        try {
            List listItems = spec.getSupportedResponseTypes().stream().map(ResponseType::toString).collect(Collectors.toList());
            this.responseSelection.replaceListItems(listItems, null);
        }
        catch (InvalidSettingsException e) {
            throw new NotConfigurableException("Could not determine supported response types; ensure that the downstream node is properly configured and executed.", (Throwable)e);
        }
        super.loadAdditionalSettingsFrom(settings, specs);
    }
}

