/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.extractor;

import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AbstractResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.maxmind.geoip2.connector.port.AbstractGeoIP2ConnectorPortObjectSpec;
import ws.palladian.nodes.maxmind.geoip2.connector.port.GeoIP2ConnectorPortObject;
import ws.palladian.nodes.maxmind.geoip2.connector.port.GeoIP2Extractor;
import ws.palladian.nodes.maxmind.geoip2.connector.port.ResponseType;
import ws.palladian.nodes.maxmind.geoip2.extractor.GeoIP2ExtractorNodeSettings;
import ws.palladian.nodes.maxmind.geoip2.extractor.mapper.ResponseMapper;
import ws.palladian.nodes.maxmind.geoip2.extractor.mapper.ResponseMappers;

class GeoIP2ExtractorNodeModel
extends SimpleStreamableFunctionNodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(GeoIP2ExtractorNodeModel.class);
    static final int INPORT_CONNECTOR = 0;
    static final int INPORT_TABLE = 1;
    private final GeoIP2ExtractorNodeSettings nodeSettings = new GeoIP2ExtractorNodeSettings();
    private GeoIP2Extractor extractor;

    protected GeoIP2ExtractorNodeModel() {
        super(new PortType[]{GeoIP2ConnectorPortObject.TYPE, BufferedDataTable.TYPE}, new PortType[]{BufferedDataTable.TYPE}, 1, 0);
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        GeoIP2ConnectorPortObject connector = (GeoIP2ConnectorPortObject)inObjects[0];
        this.extractor = connector.getSpec().createExtractor(this.nodeSettings.getResponseType());
        BufferedDataTable inTable = (BufferedDataTable)inObjects[1];
        ColumnRearranger rearranger = this.createColumnRearranger(inTable.getDataTableSpec());
        BufferedDataTable outTable = exec.createColumnRearrangeTable(inTable, rearranger, (ExecutionMonitor)exec);
        return new PortObject[]{outTable};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        AbstractGeoIP2ConnectorPortObjectSpec connectorSpec = (AbstractGeoIP2ConnectorPortObjectSpec)inSpecs[0];
        DataTableSpec tableSpec = (DataTableSpec)inSpecs[1];
        DataColumnSpec inColSpec = tableSpec.getColumnSpec(this.nodeSettings.getSettingInputColumnName().getStringValue());
        if (inColSpec == null) {
            throw new InvalidSettingsException("Please configure an input column.");
        }
        if (!inColSpec.getType().isCompatible(StringValue.class)) {
            throw new InvalidSettingsException(String.format("Column %s is not a StringValue; please reconfigure the node.", this.nodeSettings.getSettingInputColumnName()));
        }
        ResponseType responseType = (ResponseType)((Object)connectorSpec.getSupportedResponseTypes().stream().findFirst().orElseThrow(() -> new IllegalStateException("No response types available.")));
        this.nodeSettings.setResponseType(responseType);
        ColumnRearranger rearranger = this.createColumnRearranger(tableSpec);
        return new DataTableSpec[]{rearranger.createSpec()};
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec tableSpec) throws InvalidSettingsException {
        String inputColumnName = this.nodeSettings.getSettingInputColumnName().getStringValue();
        final ResponseMapper mapper = ResponseMappers.get(this.nodeSettings.getResponseType());
        final int inputColumnIdx = tableSpec.findColumnIndex(inputColumnName);
        ArrayList<Object> finalSpec = new ArrayList<Object>();
        finalSpec.addAll(mapper.getSpec());
        finalSpec.add(new DataColumnSpecCreator("MaxMind JSON", JSONCell.TYPE).createSpec());
        finalSpec.add(new DataColumnSpecCreator("Error", StringCell.TYPE).createSpec());
        final DataColumnSpec[] outputSpec = (DataColumnSpec[])GeoIP2ExtractorNodeModel.prefix(finalSpec, this.nodeSettings.getSettingOutputColumnPrefix().getStringValue()).toArray(DataColumnSpec[]::new);
        AbstractCellFactory factory = new AbstractCellFactory(true, outputSpec){

            public DataCell[] getCells(DataRow row) {
                List<DataCell> cells;
                DataCell inputCell = row.getCell(inputColumnIdx);
                if (inputCell.isMissing()) {
                    cells = Collections.nCopies(outputSpec.length, DataType.getMissingCell());
                } else {
                    String stringValue = ((StringValue)inputCell).getStringValue();
                    try {
                        InetAddress ipAddress = InetAddress.getByName(stringValue);
                        AbstractResponse result = GeoIP2ExtractorNodeModel.this.extractor.execute(ipAddress);
                        ArrayList<DataCell> resultCells = new ArrayList<DataCell>(outputSpec.length);
                        resultCells.addAll(mapper.map(result));
                        resultCells.add(JSONCellFactory.create((String)result.toJson(), (boolean)false));
                        resultCells.add(DataType.getMissingCell());
                        cells = resultCells;
                    }
                    catch (GeoIp2Exception | IOException e) {
                        cells = new ArrayList<DataCell>(Collections.nCopies(outputSpec.length, DataType.getMissingCell()));
                        cells.set(outputSpec.length - 1, (DataCell)new StringCell(e.getClass().getSimpleName() + ": " + e.getMessage()));
                        LOGGER.warnWithFormat("%s: %s for '%s': %s", new Object[]{row.getKey(), e.getClass().getSimpleName(), stringValue, e.getMessage(), e});
                    }
                }
                return (DataCell[])cells.toArray(DataCell[]::new);
            }

            public void afterProcessing() {
                if (GeoIP2ExtractorNodeModel.this.extractor != null) {
                    try {
                        GeoIP2ExtractorNodeModel.this.extractor.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        ColumnRearranger columnRearranger = new ColumnRearranger(tableSpec);
        columnRearranger.append((CellFactory)factory);
        return columnRearranger;
    }

    private static List<? extends DataColumnSpec> prefix(List<? extends DataColumnSpec> specList, String prefix) {
        return specList.stream().map(spec -> {
            String prefixedName = Optional.ofNullable(prefix).orElse("") + spec.getName();
            DataColumnSpecCreator specCreator = new DataColumnSpecCreator(spec);
            specCreator.setName(prefixedName);
            return specCreator.createSpec();
        }).collect(Collectors.toList());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }
}

