/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.extractor;

import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.maxmind.geoip2.connector.port.ResponseType;

class GeoIP2ExtractorNodeSettings {
    private static final String KEY_INPUT_COLUMN_NAME = "inputColumnName";
    private static final String KEY_OUTPUT_COLUMN_PREFIX = "ouputColumnPrefix";
    private static final String KEY_RESPONSE_TYPE = "responseType";
    private final SettingsModelString inputColumnName = new SettingsModelString("inputColumnName", null);
    private final SettingsModelString outputColumnPrefix = new SettingsModelString("ouputColumnPrefix", null);
    private final SettingsModelString responseType = new SettingsModelString("responseType", null);

    GeoIP2ExtractorNodeSettings() {
    }

    public SettingsModelString getSettingInputColumnName() {
        return this.inputColumnName;
    }

    public SettingsModelString getSettingOutputColumnPrefix() {
        return this.outputColumnPrefix;
    }

    public SettingsModelString getSettingResponseType() {
        return this.responseType;
    }

    public void saveSettings(NodeSettingsWO settings) {
        this.inputColumnName.saveSettingsTo(settings);
        this.outputColumnPrefix.saveSettingsTo(settings);
        this.responseType.saveSettingsTo(settings);
    }

    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumnName.validateSettings(settings);
        this.outputColumnPrefix.validateSettings(settings);
        this.responseType.validateSettings(settings);
    }

    public void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumnName.loadSettingsFrom(settings);
        this.outputColumnPrefix.loadSettingsFrom(settings);
        this.responseType.loadSettingsFrom(settings);
    }

    public ResponseType getResponseType() {
        return ResponseType.getByLabel(this.getSettingResponseType().getStringValue());
    }

    public void setResponseType(ResponseType type) {
        this.getSettingResponseType().setStringValue(type.toString());
    }
}

