/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.extractor.mapper;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import ws.palladian.nodes.maxmind.geoip2.connector.port.ResponseType;
import ws.palladian.nodes.maxmind.geoip2.extractor.mapper.AbstractCountryResponseMapper;
import ws.palladian.nodes.maxmind.geoip2.extractor.mapper.AsnResponseMapper;
import ws.palladian.nodes.maxmind.geoip2.extractor.mapper.ResponseMapper;

public final class ResponseMappers {
    private static final List<? extends ResponseMapper> MAPPERS = Arrays.asList(new AbstractCountryResponseMapper(ResponseType.COUNTRY), new AbstractCountryResponseMapper(ResponseType.CITY), new AsnResponseMapper(), new AbstractCountryResponseMapper(ResponseType.INSIGHTS));

    public static ResponseMapper get(ResponseType type) {
        Objects.requireNonNull(type, "type must not be null");
        return MAPPERS.stream().filter(m -> m.getType().equals((Object)type)).findFirst().orElseThrow(() -> new IllegalArgumentException("No mapper for type " + String.valueOf((Object)type)));
    }

    private ResponseMappers() {
    }
}

