/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.pug;

import de.neuland.pug4j.PugConfiguration;
import de.neuland.pug4j.template.PugTemplate;
import de.neuland.pug4j.template.ReaderTemplateLoader;
import de.neuland.pug4j.template.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import ws.palladian.nodes.templating.TemplateEngine;

class PugTemplateEngine
implements TemplateEngine {
    private static final String DEFAULT_SNIPPET = "html\n  head\n    title Handlebars Node\n  body\n    h1 Hello world!";

    PugTemplateEngine() {
    }

    public String applyTemplate(String templateString, Map<String, Object> context) throws IOException {
        PugConfiguration config = new PugConfiguration();
        config.setTemplateLoader((TemplateLoader)new ReaderTemplateLoader((Reader)new StringReader(templateString), "myTemplate"));
        config.setPrettyPrint(true);
        PugTemplate template = config.getTemplate("myTemplate");
        return config.renderTemplate(template, context);
    }

    public String getDefaultSnippet() {
        return DEFAULT_SNIPPET;
    }

    public String getName() {
        return "Pug";
    }
}

