/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.collection.hamming;

import java.util.List;
import java.util.stream.Collectors;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.collection.CollectionDataValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import org.simmetrics.ListDistance;
import ws.palladian.nodes.distances.collection.hamming.HammingDistanceConfig;

final class HammingDistance
extends SingleColumnDistanceMeasure<HammingDistanceConfig> {
    HammingDistance(HammingDistanceConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        CollectionDataValue value1 = (CollectionDataValue)this.checkNotMissing(row1, this.getIndex(), CollectionDataValue.class);
        CollectionDataValue value2 = (CollectionDataValue)this.checkNotMissing(row2, this.getIndex(), CollectionDataValue.class);
        List list1 = value1.stream().collect(Collectors.toList());
        List list2 = value2.stream().collect(Collectors.toList());
        if (list1.size() != list2.size()) {
            throw new DistanceMeasurementException(String.format("List a must have the same length as list b (%s vs %s)", list1.size(), list2.size()));
        }
        ListDistance hamming = org.simmetrics.metrics.HammingDistance.forList();
        return hamming.distance(list1, list2);
    }
}

