/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.string.smithwaterman;

import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import org.simmetrics.metrics.functions.AffineGap;
import org.simmetrics.metrics.functions.Gap;
import org.simmetrics.metrics.functions.MatchMismatch;
import org.simmetrics.metrics.functions.Substitution;
import ws.palladian.nodes.distances.string.smithwaterman.SmithWatermanConfig;

final class SmithWaterman
extends SingleColumnDistanceMeasure<SmithWatermanConfig> {
    SmithWaterman(SmithWatermanConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        String value1 = ((StringValue)this.checkNotMissing(row1, this.getIndex(), StringValue.class)).getStringValue();
        String value2 = ((StringValue)this.checkNotMissing(row2, this.getIndex(), StringValue.class)).getStringValue();
        SmithWatermanConfig config = (SmithWatermanConfig)this.getConfig();
        AffineGap gap = new AffineGap((float)config.startValue, (float)config.gapValue);
        MatchMismatch substitution = new MatchMismatch((float)config.matchValue, (float)config.mismatchValue);
        org.simmetrics.metrics.SmithWaterman smithWaterman = new org.simmetrics.metrics.SmithWaterman((Gap)gap, (Substitution)substitution, config.windowSize);
        return smithWaterman.compare(value1, value2);
    }
}

