/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.templating;

import io.github.bhowell2.debouncer.Debouncer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.json.JSONValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.DataAwareNodeDialogPane;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import org.springframework.boot.devtools.livereload.LiveReloadServer;
import ws.palladian.nodes.templating.TemplateEngine;
import ws.palladian.nodes.templating.TemplatingNodeModel;
import ws.palladian.nodes.templating.TemplatingNodeSettings;

class TemplatingNodeDialog
extends DataAwareNodeDialogPane {
    private static final String PLAIN_TEXT_PREVIEW = "<html><title>Text Preview</title><script src=\"%s\"></script></head><body><pre>%s</pre></body></html>";
    private final DefaultNodeSettingsPane delegate = new DefaultNodeSettingsPane();
    private final TemplateEngine templateEngine;
    private final TemplatingNodeSettings nodeSettings;
    private LiveReloadServer liveReloadServer;
    private Server webServer;
    private Debouncer<String> debouncer;
    private DataTableSpec spec;
    private DataRow previewRow;
    private ChangeListener changeListener;

    TemplatingNodeDialog(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        this.nodeSettings = new TemplatingNodeSettings(templateEngine);
        this.delegate.addDialogComponent((DialogComponent)new DialogComponentJTextInput((SettingsModel)this.nodeSettings.template, templateEngine.getName() + " Template"));
        this.delegate.setHorizontalPlacement(true);
        this.delegate.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.nodeSettings.variablesColumn, "Variables Column", 0, new Class[]{JSONValue.class}));
        this.delegate.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.nodeSettings.removeVariablesColumn, "Remove Variables Column"));
        this.delegate.setHorizontalPlacement(false);
        this.delegate.addDialogComponent((DialogComponent)new DialogComponentString(this.nodeSettings.outputColumn, "Output Column", true, 20));
        this.delegate.setHorizontalPlacement(true);
        this.delegate.addDialogComponent((DialogComponent)new DialogComponentStringSelection(this.nodeSettings.contentType, "Content Type", TemplatingNodeSettings.ContentType.stringValues()));
        DialogComponentButton livePreviewButton = new DialogComponentButton("Open Live Preview");
        livePreviewButton.addActionListener(e -> {
            try {
                this.startLiveServers();
                Connector webServerConnector = this.webServer.getConnectors()[0];
                int webServerPort = ((NetworkConnector)webServerConnector).getLocalPort();
                String browserUrl = String.format("http://localhost:%s/", webServerPort);
                Desktop.getDesktop().browse(new URI(browserUrl));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        this.delegate.addDialogComponent((DialogComponent)livePreviewButton);
        this.delegate.setHorizontalPlacement(false);
        Component[] componentArray = this.delegate.getPanel().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JTabbedPane) {
                JTabbedPane tabbedPane = (JTabbedPane)component;
                int idx = 0;
                while (idx < tabbedPane.getTabCount()) {
                    String title = tabbedPane.getTitleAt(idx);
                    Component tabComponent = tabbedPane.getComponent(idx);
                    this.addTab(title, tabComponent);
                    ++idx;
                }
            }
            ++n2;
        }
    }

    public void onClose() {
        super.onClose();
        this.stopLiveServers();
    }

    private void startLiveServers() throws Exception {
        if (this.liveReloadServer != null || this.webServer != null) {
            return;
        }
        this.liveReloadServer = new LiveReloadServer();
        this.liveReloadServer.start();
        this.debouncer = new Debouncer(1);
        this.changeListener = ev -> this.debouncer.addRunLast(100L, TimeUnit.MILLISECONDS, (Object)"update", k -> this.triggerReload());
        this.nodeSettings.template.addChangeListener(this.changeListener);
        this.nodeSettings.variablesColumn.addChangeListener(this.changeListener);
        this.nodeSettings.contentType.addChangeListener(this.changeListener);
        this.webServer = new Server(0);
        this.webServer.setHandler((Handler)new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                if (request.getHttpURI().getPath().equals("/")) {
                    response.setStatus(200);
                    response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/html;charset=utf-8");
                    String result = TemplatingNodeDialog.this.renderTemplate();
                    Content.Sink.write((Content.Sink)response, (boolean)true, (String)result, (Callback)callback);
                } else {
                    response.setStatus(404);
                }
                return true;
            }
        });
        this.webServer.start();
    }

    private void triggerReload() {
        if (this.liveReloadServer == null || this.webServer == null) {
            return;
        }
        try {
            this.renderTemplate();
            this.liveReloadServer.triggerReload();
        }
        catch (IOException iOException) {}
    }

    private String renderTemplate() throws IOException {
        String template = this.nodeSettings.template.getStringValue();
        String variablesColumnName = this.nodeSettings.variablesColumn.getStringValue();
        int variablesColumnIdx = this.spec.findColumnIndex(variablesColumnName);
        DataCell cell = this.previewRow.getCell(variablesColumnIdx);
        HashMap<String, Object> context = new HashMap<String, Object>();
        String liveReloadJs = String.format("http://localhost:%s/livereload.js", this.liveReloadServer.getPort());
        context.put("data", TemplatingNodeModel.getContextFromCell(cell));
        Map variables = this.getAvailableFlowVariables(TemplatingNodeModel.SUPPORTED_VARIABLE_TYPES);
        context.put("variables", TemplatingNodeModel.convertFlowVariables(variables));
        String result = this.templateEngine.applyTemplate(template, context);
        TemplatingNodeSettings.ContentType contentType = TemplatingNodeSettings.ContentType.fromString(this.nodeSettings.contentType.getStringValue());
        switch (contentType) {
            case HTML: {
                String liveReloadScript = String.format("<script src=\"%s\"></script>", liveReloadJs);
                if (!result.contains(liveReloadScript)) {
                    result = result.replace("</body>", liveReloadScript + "</body>");
                }
                return result;
            }
            case TEXT: {
                return String.format(PLAIN_TEXT_PREVIEW, liveReloadJs, StringEscapeUtils.escapeHtml4((String)result));
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)contentType));
    }

    private void stopLiveServers() {
        if (this.liveReloadServer != null) {
            try {
                this.liveReloadServer.stop();
                this.liveReloadServer = null;
            }
            catch (IOException iOException) {}
        }
        if (this.webServer != null) {
            try {
                this.webServer.stop();
                this.webServer = null;
            }
            catch (Exception exception) {}
        }
        this.nodeSettings.template.removeChangeListener(this.changeListener);
        this.nodeSettings.variablesColumn.removeChangeListener(this.changeListener);
        this.nodeSettings.contentType.removeChangeListener(this.changeListener);
        this.changeListener = null;
        if (this.debouncer != null) {
            this.debouncer.shutdown();
            this.debouncer = null;
        }
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.delegate.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, BufferedDataTable[] input) throws NotConfigurableException {
        PortObjectSpec[] specs = (PortObjectSpec[])Arrays.stream(input).map(BufferedDataTable::getSpec).toArray(PortObjectSpec[]::new);
        this.delegate.loadSettingsFrom(settings, specs);
        this.spec = (DataTableSpec)specs[0];
        this.previewRow = input[0].iterator().next();
    }

    public boolean closeOnESC() {
        return false;
    }

    private static final class DialogComponentJTextInput
    extends DialogComponent {
        RSyntaxTextArea textArea = new RSyntaxTextArea(20, 60);

        private DialogComponentJTextInput(SettingsModel model, String title) {
            super(model);
            this.getComponentPanel().setLayout(new BorderLayout());
            this.getComponentPanel().add((Component)new JLabel(title), "North");
            this.textArea.setCodeFoldingEnabled(true);
            this.textArea.setSyntaxEditingStyle("text/html");
            this.textArea.setAntiAliasingEnabled(true);
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateModel();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateModel();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateModel();
                }

                private void updateModel() {
                    SettingsModelString model = (SettingsModelString)this.getModel();
                    model.setStringValue(textArea.getText());
                }
            });
            this.getComponentPanel().add((Component)new RTextScrollPane((RTextArea)this.textArea), "Center");
        }

        protected void updateComponent() {
            SettingsModelString model = (SettingsModelString)this.getModel();
            if (!this.textArea.getText().equals(model.getStringValue())) {
                this.textArea.setText(model.getStringValue());
            }
            this.setEnabledComponents(this.getModel().isEnabled());
        }

        protected void validateSettingsBeforeSave() throws InvalidSettingsException {
        }

        protected void checkConfigurabilityBeforeLoad(PortObjectSpec[] specs) throws NotConfigurableException {
        }

        protected void setEnabledComponents(boolean enabled) {
            this.textArea.setEnabled(enabled);
        }

        public void setToolTipText(String text) {
        }
    }
}

