/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.regextractor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

enum PatternFlag {
    UNIX_LINES(1, Character.valueOf('d')),
    CASE_INSENSITIVE(2, Character.valueOf('i')),
    COMMENTS(4, Character.valueOf('x')),
    MULTILINE(8, Character.valueOf('m')),
    LITERAL(16, null),
    DOTALL(32, Character.valueOf('s')),
    UNICODE_CASE(64, Character.valueOf('u')),
    CANON_EQ(128, null),
    UNICODE_CHARACTER_CLASS(256, Character.valueOf('U'));

    private final int flag;
    private final Character characterFlag;

    private PatternFlag(int flag, Character characterFlag) {
        this.flag = flag;
        this.characterFlag = characterFlag;
    }

    public Optional<Character> characterFlag() {
        return Optional.ofNullable(this.characterFlag);
    }

    public static Set<PatternFlag> parseCombinedFlag(int value) {
        return Arrays.stream(PatternFlag.values()).filter(flag -> (flag.flag & value) != 0).collect(Collectors.toSet());
    }

    public static int getCombinedFlag(Collection<PatternFlag> flags) {
        return flags != null ? flags.stream().mapToInt(v -> v.flag).sum() : 0;
    }

    public static int getCombinedFlag(PatternFlag ... flags) {
        return PatternFlag.getCombinedFlag(Arrays.asList(flags));
    }

    public String toString() {
        Object str = super.toString();
        str = (String)str + this.characterFlag().map(f -> " (" + String.valueOf(this.characterFlag) + ")").orElse("");
        return str;
    }
}

