/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.regextractor;

class TimeoutCharSequence
implements CharSequence {
    private final CharSequence inner;
    private long start = 0L;
    private final long timeoutMs;

    public TimeoutCharSequence(CharSequence inner, long timeoutMs) {
        this.inner = inner;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public char charAt(int index) {
        this.checkTimeout();
        return this.inner.charAt(index);
    }

    private void checkTimeout() {
        long elapsedTime;
        if (this.timeoutMs < 0L) {
            return;
        }
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        if ((elapsedTime = System.currentTimeMillis() - this.start) > this.timeoutMs) {
            throw new RuntimeException(new InterruptedException("Interrupted at chatAt(int) after " + elapsedTime + " ms."));
        }
    }

    @Override
    public int length() {
        return this.inner.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new TimeoutCharSequence(this.inner.subSequence(start, end), this.timeoutMs);
    }

    @Override
    public String toString() {
        return this.inner.toString();
    }
}

