/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.knime.core.node.NodeLogger;
import ws.palladian.nodes.StringUtils;

public final class ExtensionPointUtil {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ExtensionPointUtil.class);

    private ExtensionPointUtil() {
    }

    public static <T> List<T> loadExtensions(String extensionPointId, String attributeName) {
        Objects.requireNonNull(extensionPointId, "extensionPointId was null");
        Objects.requireNonNull(attributeName, "attributeName was null");
        ArrayList<Object> extensions = new ArrayList<Object>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(extensionPointId);
        if (point == null) {
            throw new IllegalStateException("No extension for '" + extensionPointId + "'.");
        }
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String constructorClassName = element.getAttribute(attributeName);
            if (StringUtils.nullOrEmpty(constructorClassName)) {
                LOGGER.errorWithFormat("Extension is missing attribute '%s'.", new Object[]{attributeName});
            } else {
                try {
                    Object instance = element.createExecutableExtension(attributeName);
                    extensions.add(instance);
                }
                catch (CoreException e) {
                    LOGGER.error((Object)("Could not instantiate '" + constructorClassName + "'."), (Throwable)e);
                }
            }
            ++n2;
        }
        return Collections.unmodifiableList(extensions);
    }
}

