/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes;

import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import ws.palladian.helper.AbstractProgressReporter;

public class KnimeProgressAdapter
extends AbstractProgressReporter {
    private final ExecutionMonitor exec;
    protected long totalSteps;
    protected long currentSteps;

    public KnimeProgressAdapter(ExecutionMonitor exec) {
        this.exec = exec;
    }

    public void startTask(String description, long totalSteps) {
        this.totalSteps = totalSteps;
        this.exec.setProgress(description);
    }

    public void increment(long steps) {
        this.currentSteps += steps;
        double p = this.getProgress();
        this.setExecProgressAndCheckCanceled(p);
    }

    public double getProgress() {
        return this.totalSteps > 0L ? (double)this.currentSteps / (double)this.totalSteps : 0.0;
    }

    public void finishTask() {
        this.exec.setProgress(1.0);
    }

    public void add(double progress) {
        Double temp = this.exec.getProgressMonitor().getProgress();
        double oldProgress = temp != null ? temp : 0.0;
        this.setExecProgressAndCheckCanceled(oldProgress + progress);
    }

    private void setExecProgressAndCheckCanceled(double p) {
        this.exec.setProgress(p);
        try {
            this.exec.checkCanceled();
        }
        catch (CanceledExecutionException e) {
            throw new CanceledExceptionWrapper(e);
        }
    }

    public final class CanceledExceptionWrapper
    extends RuntimeException {
        public CanceledExceptionWrapper(CanceledExecutionException e) {
            super(e);
        }
    }
}

