/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes;

import com.nodepit.licensing.LicenseException;
import com.nodepit.licensing.LicenseInformation;
import com.nodepit.licensing.LicenseManager;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.knime.core.node.NodeLogger;
import org.osgi.framework.BundleContext;
import ws.palladian.helper.functional.Factory;
import ws.palladian.nodes.retrieval.EclipseProxyProvider;
import ws.palladian.retrieval.HttpRetriever;
import ws.palladian.retrieval.HttpRetrieverFactory;
import ws.palladian.retrieval.ProxyProvider;

public class PalladianPluginActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "ws.palladian.nodes";
    private static PalladianPluginActivator plugin;
    private static final NodeLogger LOGGER;
    private static final String SERVER_LICENSE_FEATURE_KEY = "knimeServer";
    public static final String FEATURE_LOCAL_LOCATION_SOURCE = "localLocationSource";
    private static final String LICENSE_LOG_MESSAGE = "\n******************************************************************************** \n  It looks like this workflow is executed on a KNIME Server, which requires a \n  valid license. In case of questions, please contact mail@palladian.ws. \n********************************************************************************";

    static {
        LOGGER = NodeLogger.getLogger(PalladianPluginActivator.class);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        HttpRetrieverFactory.setFactory((Factory)new HttpRetrieverFactory(){

            public HttpRetriever create() {
                HttpRetriever retriever = super.create();
                retriever.setProxyProvider((ProxyProvider)EclipseProxyProvider.INSTANCE);
                return retriever;
            }
        });
        LOGGER.debug((Object)"Palladian version 3.0.0-SNAPSHOT (build 2025-12-23 15:00:29)\nCopyright 2009-2025 by David Urbansky, Philipp Katz, Klemens Muthmann\n");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static PalladianPluginActivator getDefault() {
        return plugin;
    }

    public Image getImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
            this.getImageRegistry().put(path, imageDescriptor);
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public static void checkLicense() {
        if (PalladianPluginActivator.isRunningOnKNIMEServer()) {
            LicenseInformation license;
            try {
                license = LicenseManager.getProduct((String)PLUGIN_ID).getLicense();
            }
            catch (LicenseException e) {
                LOGGER.error((Object)LICENSE_LOG_MESSAGE);
                throw new IllegalStateException(e.getMessage() + "\nPlease check the console log for more details.");
            }
            if (!license.getBooleanFeature(SERVER_LICENSE_FEATURE_KEY)) {
                LOGGER.error((Object)LICENSE_LOG_MESSAGE);
                throw new IllegalStateException("The specified license is not valid for a KNIME Server environment. \nPlease check the console log for more details.");
            }
        }
    }

    public static void checkLicenseFeature(String featureKey) {
        LicenseInformation license;
        try {
            license = LicenseManager.getProduct((String)PLUGIN_ID).getLicense();
        }
        catch (LicenseException licenseException) {
            throw new IllegalStateException("This feature requires a license (feature key=" + featureKey + ")");
        }
        if (!license.getBooleanFeature(featureKey)) {
            throw new IllegalStateException("This feature requires a license (feature key=" + featureKey + ")");
        }
    }

    private static boolean isRunningOnKNIMEServer() {
        String enterpriseApplicationClass = "com.knime.enterprise.executor.KNIMEExecutorApplication";
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        Iterator<StackTraceElement[]> iterator = stackTraces.values().iterator();
        while (iterator.hasNext()) {
            StackTraceElement[] stackTraceElements;
            StackTraceElement[] stackTraceElementArray = stackTraceElements = iterator.next();
            int n = stackTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (stackTraceElement.getClassName().startsWith(enterpriseApplicationClass)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

