/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.knime.core.data.util.NonClosableInputStream;
import org.knime.core.data.util.NonClosableOutputStream;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.ModelContent;
import org.knime.core.node.ModelContentRO;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortObjectZipInputStream;
import org.knime.core.node.port.PortObjectZipOutputStream;
import org.knime.core.node.port.PortType;
import org.knime.core.node.port.PortTypeRegistry;
import ws.palladian.classification.text.DictionaryModel;
import ws.palladian.nodes.classification.text.AbstractTextClassifierPortObject;
import ws.palladian.nodes.classification.text.FileBackedTextClassifierPortObjectCache;
import ws.palladian.nodes.classification.text.TextClassifierPortObjectSpec;

@Deprecated
public class FileBackedTextClassifierPortObject
extends AbstractTextClassifierPortObject {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(FileBackedTextClassifierPortObject.class);
    public static final PortType TYPE = PortTypeRegistry.getInstance().getPortType(FileBackedTextClassifierPortObject.class);
    private final String identifier;
    private final int numUniqTerms;
    private final int numCategories;
    private final int numEntries;

    public FileBackedTextClassifierPortObject(TextClassifierPortObjectSpec spec, DictionaryModel model) {
        super(spec);
        this.identifier = UUID.randomUUID().toString();
        this.numUniqTerms = model.getNumUniqTerms();
        this.numCategories = model.getNumCategories();
        this.numEntries = model.getNumEntries();
        FileBackedTextClassifierPortObjectCache.getInstance().put(this.identifier, model);
    }

    private FileBackedTextClassifierPortObject(TextClassifierPortObjectSpec spec, String identifier, int numUniqTerms, int numCategories, int numEntries) {
        super(spec);
        this.identifier = identifier;
        this.numUniqTerms = numUniqTerms;
        this.numCategories = numCategories;
        this.numEntries = numEntries;
    }

    public String getSummary() {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
        return String.format("Dictionary %s: %s terms, %s categories, %s entries", this.identifier, format.format(this.numUniqTerms), format.format(this.numCategories), format.format(this.numEntries));
    }

    @Override
    public DictionaryModel getModel() {
        return FileBackedTextClassifierPortObjectCache.getInstance().get(this.identifier);
    }

    private File getSerializedDictionaryFile() {
        return FileBackedTextClassifierPortObjectCache.getInstance().getTempFile(this.identifier);
    }

    public static class Serializer
    extends PortObject.PortObjectSerializer<FileBackedTextClassifierPortObject> {
        private static final Object WRITE_LOCK = new Object();
        private static final String META_DATA = "metaData.xml";
        private static final String IDENTIFIER = "identifier";
        private static final String NUM_UNIQ_TERMS = "numUniqTerms";
        private static final String NUM_CATEGORIES = "numCategories";
        private static final String NUM_ENTRIES = "numEntries";
        private static final String FILE_NAME = "textClassifier.ser";

        public void savePortObject(FileBackedTextClassifierPortObject portObject, PortObjectZipOutputStream out, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
            out.putNextEntry(new ZipEntry(META_DATA));
            ModelContent metaContent = new ModelContent(META_DATA);
            metaContent.addString(IDENTIFIER, portObject.identifier);
            metaContent.addInt(NUM_UNIQ_TERMS, portObject.numUniqTerms);
            metaContent.addInt(NUM_CATEGORIES, portObject.numCategories);
            metaContent.addInt(NUM_ENTRIES, portObject.numEntries);
            metaContent.saveToXML((OutputStream)new NonClosableOutputStream.Zip((ZipOutputStream)out));
            out.putNextEntry(new ZipEntry(FILE_NAME));
            File source = portObject.getSerializedDictionaryFile();
            LOGGER.info((Object)("Saving " + String.valueOf(source) + " in PortObject"));
            exec.setMessage("Saving " + String.valueOf(source) + " in PortObject");
            Files.copy(source.toPath(), (OutputStream)out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileBackedTextClassifierPortObject loadPortObject(PortObjectZipInputStream in, PortObjectSpec spec, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
            int numEntries;
            int numCategories;
            int numUniqTerms;
            String identifier;
            String entryName = in.getNextEntry().getName();
            if (!META_DATA.equals(entryName)) {
                throw new IOException("ZIP entry has unexpected name: " + entryName + ", expected metaData.xml");
            }
            ModelContentRO metaContent = ModelContent.loadFromXML((InputStream)new NonClosableInputStream.Zip((ZipInputStream)in));
            try {
                identifier = metaContent.getString(IDENTIFIER);
                numUniqTerms = metaContent.getInt(NUM_UNIQ_TERMS);
                numCategories = metaContent.getInt(NUM_CATEGORIES);
                numEntries = metaContent.getInt(NUM_ENTRIES);
            }
            catch (InvalidSettingsException invalidSettingsException) {
                throw new IOException("One of the required settings keys was missing.");
            }
            entryName = in.getNextEntry().getName();
            if (!FILE_NAME.equals(entryName)) {
                throw new IOException("ZIP entry has unexpected name: " + entryName + ", expected textClassifier.ser");
            }
            File target = FileBackedTextClassifierPortObjectCache.getInstance().getTempFile(identifier);
            Object object = WRITE_LOCK;
            synchronized (object) {
                if (target.isFile()) {
                    LOGGER.info((Object)("File " + String.valueOf(target) + " for PortObject already exists."));
                } else {
                    LOGGER.info((Object)("Copy PortObject to " + String.valueOf(target)));
                    exec.setMessage("Copy PortObject to " + String.valueOf(target));
                    Files.copy((InputStream)in, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            return new FileBackedTextClassifierPortObject((TextClassifierPortObjectSpec)spec, identifier, numUniqTerms, numCategories, numEntries);
        }
    }
}

