/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.IntValue;
import org.knime.core.data.StringValue;
import org.knime.core.data.util.memory.MemoryAlert;
import org.knime.core.data.util.memory.MemoryAlertListener;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.NodeLogger;
import ws.palladian.core.Instance;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.nodes.classification.text.TextClassifierLearnerNodeModel;

class RowTrainableConverter
extends MemoryAlertListener
implements Function<DataRow, Instance> {
    private static final NodeLogger logger = NodeLogger.getLogger(TextClassifierLearnerNodeModel.class);
    private final ExecutionContext exec;
    private final int textIndex;
    private final int categoryIndex;
    private final int weightIndex;
    private final long rowCount;
    private int currentRow = 0;
    private final Set<String> categories = new HashSet<String>();
    private boolean receivedMemoryWarning = false;

    RowTrainableConverter(ExecutionContext exec, int textIndex, int categoryIndex, int weightIndex, long rowCount) {
        if (textIndex < 0 || categoryIndex < 0) {
            throw new IllegalArgumentException("textIndex and/or categoryIndex was -1.");
        }
        this.exec = exec;
        this.textIndex = textIndex;
        this.categoryIndex = categoryIndex;
        this.weightIndex = weightIndex;
        this.rowCount = rowCount;
    }

    @Override
    public Instance apply(DataRow row) {
        DataCell weightCell;
        if (this.receivedMemoryWarning) {
            throw new RuntimeException("Received memory warning, cancelled training after " + this.currentRow + " rows. Reduce number of training documents, change feature settings, or increase KNIME memory.");
        }
        if (this.rowCount != -1L) {
            this.exec.setProgress((double)this.currentRow++ / (double)this.rowCount, "Processing row " + this.currentRow);
        } else {
            this.exec.setProgress("Processing row " + this.currentRow);
        }
        DataCell textCell = row.getCell(this.textIndex);
        DataCell categoryCell = row.getCell(this.categoryIndex);
        if (textCell.isMissing() || categoryCell.isMissing()) {
            logger.warn((Object)("Row " + row.getKey().getString() + " contains no text and/or category, skipping for training."));
            return null;
        }
        String text = ((StringValue)textCell).getStringValue();
        String category = ((StringValue)categoryCell).getStringValue();
        int weight = 1;
        if (this.weightIndex != -1 && !(weightCell = row.getCell(this.weightIndex)).isMissing()) {
            weight = ((IntValue)weightCell).getIntValue();
        }
        if (weight < 1) {
            logger.debug((Object)("Skipping row " + row.getKey().getString() + " with weight " + weight));
            return null;
        }
        try {
            this.exec.checkCanceled();
        }
        catch (CanceledExecutionException e) {
            throw new RuntimeException(e);
        }
        this.categories.add(category);
        return new InstanceBuilder().setText(text).weight(weight).create(category);
    }

    public int getNumCategories() {
        return this.categories.size();
    }

    protected boolean memoryAlert(MemoryAlert alert) {
        if (!this.receivedMemoryWarning) {
            logger.debug((Object)("Received memory warning, usedMemory = " + alert.getUsedMemory() + ", maxMemory = " + alert.getMaxMemory()));
        }
        this.receivedMemoryWarning = true;
        return false;
    }
}

