/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.NodeSettings;
import ws.palladian.nodes.classification.text.FeatureSettingsConfiguration;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class TextClassifierLearnerSettings
implements NodeSettings {
    private static final String CFGKEY_TEXT_COLUMN_NAME = "settingTextColumn";
    private static final String CFGKEY_CATEGORY_COLUMN_NAME = "settingCategoryColumn";
    private static final String CFGKEY_WEIGHT = "documentWeight";
    private static final String CFGKEY_DISABLE_MEMORY_WARNING = "disableMemoryWarnings";
    final SettingsModelString textColumn = TextClassifierLearnerSettings.createSettingsTextColumn();
    final SettingsModelString categoryColumn = TextClassifierLearnerSettings.createSettingsCategoryColumn();
    final SettingsModelString weightColumn = TextClassifierLearnerSettings.createSettingsDocumentWeight();
    final FeatureSettingsConfiguration featureSettings = new FeatureSettingsConfiguration();
    final SettingsModelBoolean disableMemoryWarnings = new SettingsModelBoolean("disableMemoryWarnings", false);

    TextClassifierLearnerSettings() {
    }

    private static SettingsModelString createSettingsTextColumn() {
        return new SettingsModelString(CFGKEY_TEXT_COLUMN_NAME, null);
    }

    private static SettingsModelString createSettingsCategoryColumn() {
        return new SettingsModelString(CFGKEY_CATEGORY_COLUMN_NAME, null);
    }

    private static SettingsModelString createSettingsDocumentWeight() {
        return new SettingsModelString(CFGKEY_WEIGHT, null);
    }

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        this.textColumn.saveSettingsTo(settings);
        this.categoryColumn.saveSettingsTo(settings);
        this.weightColumn.saveSettingsTo(settings);
        this.featureSettings.saveSettingsTo(settings);
        this.disableMemoryWarnings.saveSettingsTo(settings);
    }

    @Override
    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.textColumn.loadSettingsFrom(settings);
        this.categoryColumn.loadSettingsFrom(settings);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.weightColumn);
        this.featureSettings.loadValidatedSettingsFrom(settings);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.disableMemoryWarnings);
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.textColumn.validateSettings(settings);
        this.categoryColumn.validateSettings(settings);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.weightColumn);
        this.featureSettings.validateSettings(settings);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.disableMemoryWarnings);
    }
}

