/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import org.knime.core.data.filestore.FileStore;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeCreationContext;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import ws.palladian.classification.text.DictionaryModel;
import ws.palladian.helper.ProgressReporter;
import ws.palladian.helper.io.ProgressReporterInputStream;
import ws.palladian.nodes.KnimeProgressAdapter;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.classification.text.FileStoreTextClassifierPortObject;
import ws.palladian.nodes.classification.text.TextClassifierModelReaderNodeDialog;
import ws.palladian.nodes.classification.text.TextClassifierPortObjectSpec;

public class TextClassifierModelReaderNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(TextClassifierModelReaderNodeModel.class);
    static final String CFGKEY_INPUT_FILE = "inputFile";
    private final SettingsModelString settingInputFile = TextClassifierModelReaderNodeDialog.createSettingsFilePath();

    protected TextClassifierModelReaderNodeModel() {
        super(new PortType[0], new PortType[]{FileStoreTextClassifierPortObject.TYPE});
    }

    protected TextClassifierModelReaderNodeModel(NodeCreationContext context) {
        this();
        this.settingInputFile.setStringValue(context.getUrl().toString());
    }

    protected PortObject[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        Object deserializedObject;
        PalladianPluginActivator.checkLicense();
        String filePath = this.settingInputFile.getStringValue();
        URL url = TextClassifierModelReaderNodeModel.getURLFromSettings(filePath);
        KnimeProgressAdapter reporter = new KnimeProgressAdapter((ExecutionMonitor)exec);
        Throwable throwable = null;
        Object var8_8 = null;
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream((InputStream)new ProgressReporterInputStream(url.openStream(), (ProgressReporter)reporter)));){
            deserializedObject = objectInputStream.readObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!(deserializedObject instanceof DictionaryModel)) {
            throw new IllegalStateException("The deserialized object is not of type DictionaryModel (actual: " + deserializedObject.getClass().getCanonicalName() + ")");
        }
        DictionaryModel classifier = (DictionaryModel)deserializedObject;
        TextClassifierPortObjectSpec spec = new TextClassifierPortObjectSpec();
        FileStore fileStore = exec.createFileStore(UUID.randomUUID().toString());
        return new PortObject[]{FileStoreTextClassifierPortObject.createPortObject(spec, classifier, fileStore)};
    }

    protected void reset() {
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        String inputFile = this.settingInputFile.getStringValue();
        if (inputFile == null) {
            throw new InvalidSettingsException("Specify an input file to read.");
        }
        URL url = TextClassifierModelReaderNodeModel.getURLFromSettings(inputFile);
        if ("file".equals(url.getProtocol())) {
            File file;
            try {
                file = new File(url.toURI()).getAbsoluteFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InvalidSettingsException("Invalid URL: \"" + inputFile + "\".");
            }
            if (!file.exists()) {
                throw new InvalidSettingsException("The specified file \"" + inputFile + "\" does not exist.");
            }
            if (!file.isFile()) {
                throw new InvalidSettingsException("The specified input \"" + inputFile + "\" is not a file.");
            }
            logger.debug((Object)(String.valueOf(file) + " exists."));
        }
        return new PortObjectSpec[]{new TextClassifierPortObjectSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputFile.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputFile.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputFile.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    static URL getURLFromSettings(String fileS) throws InvalidSettingsException {
        if (fileS == null || fileS.length() == 0) {
            throw new InvalidSettingsException("No file/url specified");
        }
        try {
            return new URL(fileS);
        }
        catch (MalformedURLException malformedURLException) {
            File tmp = new File(fileS);
            if (tmp.isFile() && tmp.canRead()) {
                try {
                    return tmp.getAbsoluteFile().toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    throw new InvalidSettingsException((Throwable)e1);
                }
            }
            throw new InvalidSettingsException("File/URL \"" + fileS + "\" cannot be parsed as a URL or represents a non exising file location");
        }
    }
}

