/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.knime.core.data.renderer.AbstractPainterDataValueRenderer;
import org.knime.core.data.renderer.DataValueRenderer;
import org.knime.core.node.NodeLogger;
import ws.palladian.extraction.multimedia.ImageHandler;
import ws.palladian.helper.collection.LruMap;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;

@Deprecated
public final class GeoCoordinateMapRenderer
extends AbstractPainterDataValueRenderer {
    private static final NodeLogger logger = NodeLogger.getLogger(GeoCoordinateMapRenderer.class);
    private static final long serialVersionUID = 1L;
    private static final String DESCRIPTION = "Coordinates on Google Maps";
    private static final int SIZE = 100;
    private static final Dimension DIMENSION = new Dimension(100, 100);
    private static final int IMAGE_CACHE_SIZE = 250;
    public static final DataValueRenderer INSTANCE = new GeoCoordinateMapRenderer();
    private LruMap<String, BufferedImage> cache = LruMap.insertionOrder((int)250);
    private GeoCoordinateValue coordinate;

    private GeoCoordinateMapRenderer() {
    }

    protected void setValue(Object value) {
        this.coordinate = value instanceof GeoCoordinateValue ? (GeoCoordinateValue)value : null;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.coordinate != null) {
            this.drawMapImage(g);
        }
    }

    public Dimension getPreferredSize() {
        return DIMENSION;
    }

    private void drawMapImage(Graphics graphics) {
        String getUrl = GeoCoordinateMapRenderer.createUrl(this.coordinate);
        BufferedImage image = (BufferedImage)this.cache.get((Object)getUrl);
        if (image == null) {
            logger.debug((Object)("GETting URL " + getUrl));
            image = ImageHandler.load((String)getUrl);
            this.cache.put((Object)getUrl, (Object)image);
        }
        graphics.drawImage(image, 0, 0, null);
    }

    private static String createUrl(GeoCoordinate coordinate) {
        String getUrl = String.format("http://maps.googleapis.com/maps/api/staticmap?center=%s,%s&maptype=terrain&zoom=3&size=%sx%s&markers=color:red%%7Csize:mid%%7C%s,%s&sensor=false", coordinate.getLatitude(), coordinate.getLongitude(), 100, 100, coordinate.getLatitude(), coordinate.getLongitude());
        return getUrl;
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

