/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.extraction.location.Location;
import ws.palladian.extraction.location.LocationAnnotation;
import ws.palladian.extraction.location.LocationExtractor;
import ws.palladian.extraction.location.LocationSource;
import ws.palladian.extraction.location.PalladianLocationExtractor;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location.LocationExtractorNodeDialog;
import ws.palladian.nodes.extraction.location.source.LocationSourceRegistry;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

@Deprecated
public class LocationExtractorNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(LocationExtractorNodeModel.class);
    static final String CFGKEY_INPUT_COLUMN_NAME = "settingInputColumn";
    private final SettingsModelString settingInputColumn = LocationExtractorNodeDialog.createSettingsInputColumn();

    protected LocationExtractorNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inputTable = inData[0];
        DataTableSpec inputSpec = inputTable.getDataTableSpec();
        DataTableSpec outputSpec = this.createOutputTableSpec(inputSpec);
        LocationExtractor locationExtractor = this.createLocationExtractor();
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        long outRowIndex = 0L;
        long inRowIndex = 0L;
        long inRowCount = inputTable.size();
        int textColumnIndex = inputSpec.findColumnIndex(this.settingInputColumn.getStringValue());
        if (textColumnIndex < 0) {
            throw new IllegalArgumentException("Invalid settings for input column (" + textColumnIndex + "). Please (re)configure the node correctly.");
        }
        for (DataRow row : inputTable) {
            ++inRowIndex;
            logger.debug((Object)("Processing row " + String.valueOf(row.getKey())));
            String text = ((StringValue)row.getCell(textColumnIndex)).getStringValue();
            List annotations = locationExtractor.getAnnotations(text);
            for (LocationAnnotation annotation : annotations) {
                logger.debug((Object)("Extracted " + String.valueOf(annotation)));
                Location location = annotation.getLocation();
                GeoCoordinate coordinate = location.getCoordinate();
                RowKey rowKey = RowKey.createRowKey((long)outRowIndex++);
                StringCell nameCell = new StringCell(location.getPrimaryName());
                StringCell typeCell = new StringCell(location.getType().toString());
                DataCell coordinateCell = coordinate != null ? new GeoCoordinateCell(coordinate) : DataType.getMissingCell();
                Object populationCell = location.getPopulation() != null ? new LongCell(location.getPopulation().longValue()) : DataType.getMissingCell();
                Object trustCell = annotation.getTrust() != -1.0 ? new DoubleCell(annotation.getTrust()) : DataType.getMissingCell();
                AppendedColumnRow appendedRow = new AppendedColumnRow(rowKey, row, new DataCell[]{nameCell});
                appendedRow = new AppendedColumnRow(rowKey, (DataRow)appendedRow, new DataCell[]{typeCell});
                appendedRow = new AppendedColumnRow(rowKey, (DataRow)appendedRow, new DataCell[]{coordinateCell});
                appendedRow = new AppendedColumnRow(rowKey, (DataRow)appendedRow, new DataCell[]{populationCell});
                appendedRow = new AppendedColumnRow(rowKey, (DataRow)appendedRow, new DataCell[]{trustCell});
                container.addRowToTable((DataRow)appendedRow);
                exec.checkCanceled();
                exec.setProgress((double)inRowIndex / (double)inRowCount, "Processing row " + inRowIndex);
            }
        }
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    private LocationExtractor createLocationExtractor() {
        LocationSource locationSource = LocationSourceRegistry.createCombinedLocationSource();
        return new PalladianLocationExtractor(locationSource);
    }

    private DataTableSpec createOutputTableSpec(DataTableSpec inputSpec) {
        DataColumnSpec[] appendedSpec = new DataColumnSpec[]{new DataColumnSpecCreator("Location Name", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("Location Type", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("Location Coordinates", GeoCoordinateCell.TYPE).createSpec(), new DataColumnSpecCreator("Location Population", LongCell.TYPE).createSpec(), new DataColumnSpecCreator("Trust", DoubleCell.TYPE).createSpec()};
        return new DataTableSpec(inputSpec, new DataTableSpec(appendedSpec));
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingInputColumn.getStringValue(), StringValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingInputColumn.setStringValue(columnName);
        }
        DataTableSpec outSpec = this.createOutputTableSpec(inSpec);
        return new DataTableSpec[]{outSpec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputColumn.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

