/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.extraction.location.geocoder.Geocoder;
import ws.palladian.extraction.location.geocoder.GeocoderException;
import ws.palladian.helper.UrlHelper;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.extraction.location.GeocoderNodeDialog;
import ws.palladian.nodes.extraction.location.GeocoderNodeFactory;
import ws.palladian.nodes.extraction.location.GeocoderNodeModel;
import ws.palladian.persistence.json.JsonArray;
import ws.palladian.persistence.json.JsonException;
import ws.palladian.persistence.json.JsonObject;
import ws.palladian.retrieval.HttpException;
import ws.palladian.retrieval.HttpResult;
import ws.palladian.retrieval.HttpRetriever;
import ws.palladian.retrieval.HttpRetrieverFactory;

public class OpenCageGeocoderNodeFactory
extends GeocoderNodeFactory {
    private static final String CFGKEY_API_KEY = "apiKey";

    static SettingsModelString createSettingsApiKey() {
        return new SettingsModelString(CFGKEY_API_KEY, null);
    }

    @Override
    public NodeDialogPane createNodeDialogPane() {
        DefaultNodeSettingsPane dialog = new DefaultNodeSettingsPane();
        dialog.addDialogComponent((DialogComponent)new DialogComponentString(OpenCageGeocoderNodeFactory.createSettingsApiKey(), "API Key", true, 32));
        dialog.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(GeocoderNodeDialog.createSettingsInputColumn(), "Input", 0, new Class[]{StringValue.class}));
        return dialog;
    }

    public GeocoderNodeModel createNodeModel() {
        return new GeocoderNodeModel(){
            private final SettingsModelString settingApiKey = OpenCageGeocoderNodeFactory.createSettingsApiKey();

            @Override
            protected Geocoder createGeocoder() {
                return new Geocoder(){

                    public GeoCoordinate geoCode(String text) throws GeocoderException {
                        HttpRetriever retriever = HttpRetrieverFactory.getHttpRetriever();
                        String apiKey = settingApiKey.getStringValue();
                        if (apiKey == null || apiKey.isEmpty()) {
                            throw new IllegalArgumentException("API Key is missing.");
                        }
                        try {
                            String url = String.format("https://api.opencagedata.com/geocode/v1/json?q=%s&key=%s", UrlHelper.encodeParameter((String)text), apiKey);
                            HttpResult result = retriever.httpGet(url);
                            JsonObject jsonObject = new JsonObject(result.getStringContent());
                            JsonArray resultsArray = jsonObject.getJsonArray("results");
                            JsonObject resultObject = resultsArray.getJsonObject(0);
                            JsonObject geometryObject = resultObject.getJsonObject("geometry");
                            double lat = geometryObject.getDouble("lat");
                            double lng = geometryObject.getDouble("lng");
                            return GeoCoordinate.from((double)lat, (double)lng);
                        }
                        catch (HttpException e) {
                            throw new GeocoderException((Throwable)e);
                        }
                        catch (JsonException e) {
                            throw new GeocoderException((Throwable)e);
                        }
                    }
                };
            }

            @Override
            protected void saveSettingsTo(NodeSettingsWO settings) {
                this.settingApiKey.saveSettingsTo(settings);
                super.saveSettingsTo(settings);
            }

            @Override
            protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
                this.settingApiKey.loadSettingsFrom(settings);
                super.loadValidatedSettingsFrom(settings);
            }

            @Override
            protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
                this.settingApiKey.validateSettings(settings);
                super.validateSettings(settings);
            }
        };
    }
}

