/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.coordinate.parser;

import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.helper.geo.GeoUtils;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location.coordinate.parser.CoordinateParserSettings;

class CoordinateParserNodeModel
extends SimpleStreamableFunctionNodeModel {
    private final CoordinateParserSettings nodeSettings = new CoordinateParserSettings();

    CoordinateParserNodeModel() {
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        final int inColIdx = spec.findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
        Object appendedColumnName = this.nodeSettings.parsedColumn.getStringValue();
        if (StringUtils.nullOrEmpty((String)appendedColumnName)) {
            appendedColumnName = this.nodeSettings.inputColumn.getStringValue() + " (parsed)";
        }
        DataColumnSpec colSpec = new DataColumnSpecCreator((String)appendedColumnName, GeoCoordinateCell.TYPE).createSpec();
        SingleCellFactory cellFactory = new SingleCellFactory(colSpec){

            public DataCell getCell(DataRow row) {
                double parsedPart2;
                double parsedPart1;
                DataCell cell = row.getCell(inColIdx);
                if (cell.isMissing()) {
                    return DataType.getMissingCell();
                }
                String dmsString = ((StringValue)cell).getStringValue();
                String[] parts = dmsString.trim().split("\\s*[;, ]\\s*");
                if (parts.length != 2) {
                    return DataType.getMissingCell();
                }
                try {
                    parsedPart1 = GeoUtils.parseDms((String)parts[0]);
                    parsedPart2 = GeoUtils.parseDms((String)parts[1]);
                    if (parts[0].contains("W") || parts[0].contains("E")) {
                        double temp = parsedPart1;
                        parsedPart1 = parsedPart2;
                        parsedPart2 = temp;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        parsedPart1 = Double.parseDouble(parts[0]);
                        parsedPart2 = Double.parseDouble(parts[1]);
                        if (!GeoUtils.isValidCoordinateRange((double)parsedPart1, (double)parsedPart2)) {
                            double temp = parsedPart1;
                            parsedPart1 = parsedPart2;
                            parsedPart2 = temp;
                        }
                        if (!GeoUtils.isValidCoordinateRange((double)parsedPart1, (double)parsedPart2)) {
                            return DataType.getMissingCell();
                        }
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return DataType.getMissingCell();
                    }
                }
                return new GeoCoordinateCell(parsedPart1, parsedPart2);
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)cellFactory);
        if (this.nodeSettings.dropInputColumn.getBooleanValue()) {
            rearranger.remove(new int[]{inColIdx});
        }
        return rearranger;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }
}

