/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.knime.core.node.NodeLogger;
import ws.palladian.extraction.location.LocationSource;
import ws.palladian.extraction.location.sources.CombinedLocationSource;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.source.LocationSourceFactory;
import ws.palladian.nodes.extraction.location.source.LocationSourceSetting;
import ws.palladian.nodes.extraction.location.source.LocationSourceSettings;

@Deprecated
public final class LocationSourceRegistry {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(LocationSourceRegistry.class);
    private static final String EXTENSION_POINT_ID = "ws.palladian.nodes.LocationSourceFactory";
    private static final String ATTRIBUTE_LOCATION_SOURCE_FACTORY = "LocationSourceFactory";
    private static final Map<String, LocationSourceFactory> FACTORIES = LocationSourceRegistry.loadFactories();

    private LocationSourceRegistry() {
    }

    private static Map<String, LocationSourceFactory> loadFactories() {
        HashMap<String, LocationSourceFactory> factories = new HashMap<String, LocationSourceFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            throw new IllegalStateException("No extension for 'ws.palladian.nodes.LocationSourceFactory'.");
        }
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String factory = element.getAttribute(ATTRIBUTE_LOCATION_SOURCE_FACTORY);
            if (factory == null || factory.isEmpty()) {
                throw new IllegalStateException("Extension is missing attribute 'LocationSourceFactory'.");
            }
            try {
                LocationSourceFactory instance = (LocationSourceFactory)element.createExecutableExtension(ATTRIBUTE_LOCATION_SOURCE_FACTORY);
                LOGGER.debug((Object)("Added LocationSourceFactory '" + instance.getTypeIdentifier() + "'."));
                factories.put(instance.getTypeIdentifier(), instance);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Could not instantiate '" + factory + "'."), (Throwable)e);
            }
            ++n2;
        }
        return Collections.unmodifiableMap(factories);
    }

    public static Collection<LocationSourceFactory> getFactories() {
        return FACTORIES.values();
    }

    public static LocationSourceFactory getByTypeIdentifier(String identifer) {
        return FACTORIES.get(identifer);
    }

    public static LocationSource getSource(LocationSourceSetting setting) {
        String identifier = setting.getTypeIdentifier();
        LocationSourceFactory factory = LocationSourceRegistry.getByTypeIdentifier(identifier);
        if (factory == null) {
            throw new IllegalArgumentException("No factory with identifier '" + identifier + "' available.");
        }
        return factory.createLocationSource(setting);
    }

    public static LocationSource createCombinedLocationSource() {
        ArrayList<LocationSource> sources = new ArrayList<LocationSource>();
        IPreferenceStore preferenceStore = PalladianPluginActivator.getDefault().getPreferenceStore();
        String prefString = preferenceStore.getString("ws.palldian.locationSources");
        List<LocationSourceSetting> settings = LocationSourceSettings.getSettings(prefString);
        for (LocationSourceSetting setting : settings) {
            if (!setting.isActive()) continue;
            LocationSource locationSource = LocationSourceRegistry.getSource(setting);
            if (locationSource != null) {
                sources.add(locationSource);
                continue;
            }
            LOGGER.warn((Object)("Could not create LocationSource for '" + setting.getTitle() + "', factory class '" + setting.getTypeIdentifier() + "' is missing."));
        }
        if (sources.isEmpty()) {
            throw new IllegalStateException("No LocationSources are enabled, thus no locations can be extracted. Please check the settings and activate at least one LocationSource.");
        }
        return new CombinedLocationSource(CombinedLocationSource.QueryMode.COMBINE, sources);
    }
}

