/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.source.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.source.LocationSourceFactory;
import ws.palladian.nodes.extraction.location.source.LocationSourceSetting;

@Deprecated
final class LocationSourceWizard
extends Wizard {
    private final Collection<LocationSourceFactory> factories;
    private final SourceTypeWizardPage sourcePage = new SourceTypeWizardPage();
    private final SourceNameWizardPage namePage = new SourceNameWizardPage();
    private final Map<String, LocationSourceFactory.SourceSettingWizardPage> settingPages = new HashMap<String, LocationSourceFactory.SourceSettingWizardPage>();
    private LocationSourceSetting setting;

    public LocationSourceWizard(Collection<LocationSourceFactory> factories) {
        this.factories = factories;
        for (LocationSourceFactory f : factories) {
            this.settingPages.put(f.getTypeIdentifier(), f.getWizardPage(null));
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.sourcePage);
        this.addPage((IWizardPage)this.namePage);
        for (IWizardPage iWizardPage : this.settingPages.values()) {
            if (iWizardPage == null) continue;
            this.addPage(iWizardPage);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.sourcePage) {
            return this.namePage;
        }
        if (page == this.namePage) {
            return this.getSettingPage();
        }
        return null;
    }

    private LocationSourceFactory.SourceSettingWizardPage getSettingPage() {
        return this.settingPages.get(this.sourcePage.typeIdentifer);
    }

    public boolean canFinish() {
        LocationSourceFactory.SourceSettingWizardPage settingPage;
        return this.sourcePage.isPageComplete() && this.namePage.isPageComplete() && ((settingPage = this.getSettingPage()) == null || settingPage.isPageComplete());
    }

    public boolean performFinish() {
        this.setting = new LocationSourceSetting(this.sourcePage.typeIdentifer, this.namePage.titleInput.getText());
        LocationSourceFactory.SourceSettingWizardPage settingPage = this.getSettingPage();
        if (settingPage != null) {
            settingPage.getSettings(this.setting);
        }
        return true;
    }

    public LocationSourceSetting getSetting() {
        return this.setting;
    }

    public Image getDefaultPageImage() {
        return PalladianPluginActivator.getDefault().getImage("/resources/1428063440_map_75.png");
    }

    private final class SourceNameWizardPage
    extends WizardPage {
        private Text titleInput;

        public SourceNameWizardPage() {
            super("Name");
            this.setTitle("Source name");
            this.setMessage("Specify a name for the new location source.");
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.setControl((Control)composite);
            Label label = new Label(composite, 0);
            label.setText("Arbitrary source title:");
            this.titleInput = new Text(composite, 2048);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            this.titleInput.setLayoutData((Object)gridData);
            this.titleInput.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    SourceNameWizardPage.this.setPageComplete(SourceNameWizardPage.this.titleInput.getText().trim().length() > 0);
                }
            });
        }
    }

    private final class SourceTypeWizardPage
    extends WizardPage {
        private String typeIdentifer;

        public SourceTypeWizardPage() {
            super("Source");
            this.setTitle("Source type");
            this.setMessage("Select the type of the location source to add.");
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            this.setControl((Control)composite);
            for (final LocationSourceFactory factory : LocationSourceWizard.this.factories) {
                Button button = new Button(composite, 16);
                button.setText(factory.getReadableDescription());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button source = (Button)e.getSource();
                        if (source.getSelection()) {
                            SourceTypeWizardPage.this.typeIdentifer = factory.getTypeIdentifier();
                            SourceTypeWizardPage.this.setPageComplete(true);
                        }
                    }
                });
            }
        }
    }
}

