/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.utils;

import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;
import ws.palladian.nodes.extraction.location.utils.CoordinateToLatitudeLongitudeNodeDialog;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

public class CoordinateToLatitudeLongitudeNodeModel
extends SimpleStreamableFunctionNodeModel {
    static final String CFGKEY_INPUT_COLUMN = "coordinateInputColumn";
    private final SettingsModelString settingInputColumn = CoordinateToLatitudeLongitudeNodeDialog.createSettingsModelInputColumn();

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec) throws InvalidSettingsException {
        DataColumnSpec latSpec = new DataColumnSpecCreator("latitude", DoubleCell.TYPE).createSpec();
        DataColumnSpec lngSpec = new DataColumnSpecCreator("longitude", DoubleCell.TYPE).createSpec();
        final int coordinateIdx = dataTableSpec.findColumnIndex(this.settingInputColumn.getStringValue());
        if (coordinateIdx < 0) {
            throw new IllegalStateException("Column index was " + coordinateIdx);
        }
        AbstractCellFactory factory = new AbstractCellFactory(new DataColumnSpec[]{latSpec, lngSpec}){

            public DataCell[] getCells(DataRow row) {
                DataCell inputCell = row.getCell(coordinateIdx);
                if (inputCell.isMissing()) {
                    return new DataCell[]{DataType.getMissingCell(), DataType.getMissingCell()};
                }
                GeoCoordinateValue coordinate = (GeoCoordinateValue)inputCell;
                DoubleCell latCell = new DoubleCell(coordinate.getLatitude());
                DoubleCell lngCell = new DoubleCell(coordinate.getLongitude());
                return new DataCell[]{latCell, lngCell};
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(dataTableSpec);
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec coordinateSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingInputColumn.getStringValue(), GeoCoordinateValue.class);
        if (coordinateSpec == null) {
            coordinateSpec = PalladianKnimeHelper.guessColumn(inSpec, GeoCoordinateValue.class);
            String columnName = coordinateSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingInputColumn.setStringValue(columnName);
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputColumn.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.validateSettings(settings);
    }
}

