/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.utils;

import java.util.Collection;
import java.util.HashSet;
import org.knime.base.data.aggregation.AggregationOperator;
import org.knime.base.data.aggregation.GlobalSettings;
import org.knime.base.data.aggregation.OperatorColumnSettings;
import org.knime.base.data.aggregation.OperatorData;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataType;
import ws.palladian.helper.geo.GeoUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;

public class MidpointOperator
extends AggregationOperator {
    private Collection<GeoCoordinateValue> values = new HashSet<GeoCoordinateValue>();

    public MidpointOperator() {
        this(GlobalSettings.DEFAULT, OperatorColumnSettings.DEFAULT_EXCL_MISSING);
    }

    private MidpointOperator(GlobalSettings globalSettings, OperatorColumnSettings opColSettings) {
        super(new OperatorData("Midpoint", true, false, GeoCoordinateValue.class, false), globalSettings, opColSettings);
    }

    public String getDescription() {
        return "Calculates the geographical midpoint for a group of GeoCoordinates. The midpoint can be seen as that point, which heads downwards, when weights on the globe are put for each given coordinate and the globe rotates until the heaviest point faces downwards.";
    }

    public AggregationOperator createInstance(GlobalSettings globalSettings, OperatorColumnSettings opColSettings) {
        return new MidpointOperator(globalSettings, opColSettings);
    }

    protected boolean computeInternal(DataCell cell) {
        this.values.add((GeoCoordinateValue)cell);
        return false;
    }

    protected DataType getDataType(DataType origType) {
        return GeoCoordinateCell.TYPE;
    }

    protected DataCell getResultInternal() {
        return new GeoCoordinateCell(GeoUtils.getMidpoint(this.values));
    }

    protected void resetInternal() {
        this.values.clear();
    }
}

