/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location2.source.geonames;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.ModelContentRO;
import org.knime.core.node.ModelContentWO;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.AbstractSimplePortObjectSpec;
import ws.palladian.extraction.location.Location;
import ws.palladian.extraction.location.LocationSource;
import ws.palladian.extraction.location.sources.GeonamesLocationSource;
import ws.palladian.helper.collection.MultiMap;
import ws.palladian.helper.constants.Language;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.extraction.location2.port.AbstractLocationSourcePortObjectSpec;
import ws.palladian.nodes.extraction.location2.source.geonames.GeonamesLocationSourceNodeSettings;

public final class GeonamesLocationSourcePortObjectSpec
extends AbstractLocationSourcePortObjectSpec {
    private String username;
    private boolean retrieveHierarchy;

    public GeonamesLocationSourcePortObjectSpec() {
    }

    GeonamesLocationSourcePortObjectSpec(GeonamesLocationSourceNodeSettings nodeSettings) {
        this.username = nodeSettings.username.getStringValue();
        this.retrieveHierarchy = nodeSettings.retrieveHierarchy.getBooleanValue();
    }

    protected void save(ModelContentWO model) {
        model.addString("username", this.username);
        model.addBoolean("retrieveHierarchy", this.retrieveHierarchy);
    }

    protected void load(ModelContentRO model) throws InvalidSettingsException {
        this.username = model.getString("username");
        this.retrieveHierarchy = model.getBoolean("retrieveHierarchy");
    }

    @Override
    public LocationSource createSource() {
        return new RetryingLocationSource(GeonamesLocationSource.newCachedLocationSource((String)this.username, (boolean)this.retrieveHierarchy));
    }

    @Override
    protected String getSummary() {
        return "Username: " + this.username;
    }

    private static final class RetryingLocationSource
    implements LocationSource {
        private static final NodeLogger LOGGER = NodeLogger.getLogger(RetryingLocationSource.class);
        private static final int NUM_ATTEMPTS = 3;
        private static final int WAIT_BETWEEN_ATTEMPTS_MS = 500;
        private final LocationSource wrapped;

        private RetryingLocationSource(LocationSource wrapped) {
            this.wrapped = wrapped;
        }

        public int size() {
            return RetryingLocationSource.retry(() -> this.wrapped.size());
        }

        public MultiMap<String, Location> getLocations(Collection<String> locationNames, Set<Language> languages, GeoCoordinate coordinate, double distance) {
            return RetryingLocationSource.retry(() -> this.wrapped.getLocations(locationNames, languages, coordinate, distance));
        }

        public List<Location> getLocations(GeoCoordinate coordinate, double distance) {
            return RetryingLocationSource.retry(() -> this.wrapped.getLocations(coordinate, distance));
        }

        public MultiMap<String, Location> getLocations(Collection<String> locationNames, Set<Language> languages) {
            return RetryingLocationSource.retry(() -> this.wrapped.getLocations(locationNames, languages));
        }

        public Collection<Location> getLocations(String locationName, Set<Language> languages) {
            return RetryingLocationSource.retry(() -> this.wrapped.getLocations(locationName, languages));
        }

        public List<Location> getLocations(List<Integer> locationIds) {
            return RetryingLocationSource.retry(() -> this.wrapped.getLocations(locationIds));
        }

        public Iterator<Location> getLocations() {
            return RetryingLocationSource.retry(() -> this.wrapped.getLocations());
        }

        public Location getLocation(int locationId) {
            return RetryingLocationSource.retry(() -> this.wrapped.getLocation(locationId));
        }

        private static <T> T retry(Supplier<T> functionCall) {
            int currentAttempt = 1;
            while (true) {
                try {
                    return functionCall.get();
                }
                catch (IllegalStateException e) {
                    if (currentAttempt == 3) {
                        LOGGER.debugWithFormat("Final attempt {} failed - giving up", new Object[]{currentAttempt, e});
                        throw e;
                    }
                    LOGGER.debugWithFormat("Attempt {} failed with {} - retrying in {} ms", new Object[]{currentAttempt, e, 500});
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++currentAttempt;
                    continue;
                }
                break;
            }
        }
    }

    public static final class Serializer
    extends AbstractSimplePortObjectSpec.AbstractSimplePortObjectSpecSerializer<GeonamesLocationSourcePortObjectSpec> {
    }
}

