/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.regex;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.philippkatz.regextractor.RegExTractor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.knime.base.data.filter.column.FilterColumnTable;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowIterator;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortType;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.regex.RegexExtractorNodeSettings;

@Deprecated
class RegexExtractorNodeModel
extends NodeModel {
    static final String MATCHINDEX_PLACEHOLDER = "$MATCHINDEX";
    private final RegexExtractorNodeSettings nodeSettings = new RegexExtractorNodeSettings();

    RegexExtractorNodeModel() {
        super(new PortType[]{BufferedDataTable.TYPE_OPTIONAL}, new PortType[]{BufferedDataTable.TYPE});
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        boolean tableConnected = inData[0] != null;
        BufferedDataTable inTable = tableConnected ? inData[0] : this.nodeSettings.createDummyInTable();
        RegExTractor extractor = this.nodeSettings.createExtractor();
        long inRowCount = tableConnected ? inTable.size() : 1L;
        long outRowIndex = 0L;
        String inColName = tableConnected ? this.nodeSettings.getInputColumnName() : "text";
        int inCellIndex = inTable.getDataTableSpec().findColumnIndex(inColName);
        BufferedDataTable filteredTable = inTable;
        if (!tableConnected || this.nodeSettings.isDropInputColumn()) {
            filteredTable = new FilterColumnTable((DataTable)filteredTable, false, new int[]{inCellIndex});
        }
        int maxMatchCount = 0;
        if (this.nodeSettings.getMapping() == RegexExtractorNodeSettings.Mapping.COLUMNS) {
            ExecutionMonitor progress = exec.createSubProgress(0.5);
            long inRowIndex = 0L;
            for (DataRow row : inTable) {
                progress.setProgress((double)inRowIndex++ / (double)inRowCount, "Determine result table structure \u2026 row " + inRowIndex + " / " + inRowCount);
                progress.checkCanceled();
                DataCell cell = row.getCell(inCellIndex);
                if (cell.isMissing()) continue;
                String text = ((StringValue)cell).getStringValue();
                RegExTractor.Result result = extractor.extract(text);
                maxMatchCount = Math.max(maxMatchCount, result.getMatches().size());
            }
        }
        DataTableSpec outSpec = this.createSpec(inTable.getDataTableSpec(), tableConnected, maxMatchCount);
        BufferedDataContainer container = exec.createDataContainer(outSpec);
        long inRowIndex = 0L;
        ExecutionMonitor progress = exec.createSubProgress(this.nodeSettings.getMapping() == RegexExtractorNodeSettings.Mapping.COLUMNS ? 0.5 : 1.0);
        RowIterator rowIterator = filteredTable.iterator();
        for (DataRow originalRow : inTable) {
            DataRow row = rowIterator.next();
            DataCell cell = originalRow.getCell(inCellIndex);
            RegExTractor.Result result = null;
            if (!cell.isMissing()) {
                String text = ((StringValue)cell).getStringValue();
                ExecutionContextCharSequence interruptibleCharSequence = new ExecutionContextCharSequence(text, (ExecutionMonitor)exec);
                result = extractor.extract(interruptibleCharSequence);
            }
            switch (this.nodeSettings.getMapping()) {
                case ROWS: 
                case ROWS_OR_MISSING: {
                    String value;
                    int groupIdx;
                    int startIdx = this.nodeSettings.isDropFullMatchColumn() ? 1 : 0;
                    int numCells = extractor.getGroupCount() + (this.nodeSettings.isAppendInputId() ? 1 : 0) - startIdx;
                    boolean didMatch = false;
                    if (result != null) {
                        for (RegExTractor.Match match2 : result) {
                            DataCell[] cells = new DataCell[numCells];
                            groupIdx = startIdx;
                            while (groupIdx < extractor.getGroupCount()) {
                                value = match2.group(groupIdx).getValue();
                                cells[groupIdx - startIdx] = value != null ? new StringCell(value) : DataType.getMissingCell();
                                ++groupIdx;
                            }
                            if (this.nodeSettings.isAppendInputId()) {
                                cells[numCells - 1] = new StringCell(row.getKey().getString());
                            }
                            container.addRowToTable((DataRow)new AppendedColumnRow(RowKey.createRowKey((long)outRowIndex++), row, cells));
                            didMatch = true;
                        }
                    }
                    if (didMatch || this.nodeSettings.getMapping() != RegexExtractorNodeSettings.Mapping.ROWS_OR_MISSING) break;
                    Object[] cells = new DataCell[numCells];
                    Arrays.fill(cells, DataType.getMissingCell());
                    if (this.nodeSettings.isAppendInputId()) {
                        cells[numCells - 1] = new StringCell(row.getKey().getString());
                    }
                    container.addRowToTable((DataRow)new AppendedColumnRow(RowKey.createRowKey((long)outRowIndex++), row, (DataCell[])cells));
                    break;
                }
                case SINGLE_ROW: {
                    int startIdx = this.nodeSettings.isDropFullMatchColumn() ? 1 : 0;
                    int numCells = extractor.getGroupCount() - startIdx;
                    DataCell[] cells = new DataCell[numCells];
                    int groupIdx = startIdx;
                    while (groupIdx < extractor.getGroupCount()) {
                        String value = result != null && result.matchCount() > 0 ? result.match(0).group(groupIdx).getValue() : null;
                        cells[groupIdx - startIdx] = value != null ? new StringCell(value) : DataType.getMissingCell();
                        ++groupIdx;
                    }
                    container.addRowToTable((DataRow)new AppendedColumnRow(row, cells));
                    break;
                }
                case COLUMNS: {
                    String value;
                    int groupIdx;
                    int startIdx = this.nodeSettings.isDropFullMatchColumn() ? 1 : 0;
                    int numCells = maxMatchCount * (extractor.getGroupCount() - startIdx);
                    Object[] cells = new DataCell[numCells];
                    Arrays.fill(cells, DataType.getMissingCell());
                    int arrayIdx = 0;
                    if (result != null) {
                        for (RegExTractor.Match match3 : result) {
                            groupIdx = startIdx;
                            while (groupIdx < match3.groupCount()) {
                                value = match3.group(groupIdx).getValue();
                                cells[arrayIdx++] = value != null ? new StringCell(value) : DataType.getMissingCell();
                                ++groupIdx;
                            }
                        }
                    }
                    container.addRowToTable((DataRow)new AppendedColumnRow(row, (DataCell[])cells));
                    break;
                }
                case JSON: {
                    String json = new ObjectMapper().writeValueAsString(result);
                    ListCell resultCell = result != null ? JSONCellFactory.create((String)json, (boolean)false) : DataType.getMissingCell();
                    container.addRowToTable((DataRow)new AppendedColumnRow(row, new DataCell[]{resultCell}));
                    break;
                }
                case LIST: {
                    List<Object> cells = new ArrayList();
                    if (result != null) {
                        cells = result.getMatches().stream().flatMap(match -> match.getGroups().stream().skip(this.nodeSettings.isDropFullMatchColumn() ? 1 : 0)).filter(group -> group.getValue() != null).map(group -> new StringCell(group.getValue())).collect(Collectors.toList());
                    }
                    ListCell resultCell = CollectionCellFactory.createListCell(cells);
                    container.addRowToTable((DataRow)new AppendedColumnRow(row, new DataCell[]{resultCell}));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unimplemented: " + String.valueOf((Object)this.nodeSettings.getMapping()));
                }
            }
            progress.checkCanceled();
            progress.setProgress((double)(++inRowIndex) / (double)inRowCount, "Extracting \u2026 row " + inRowIndex + " / " + inRowCount);
        }
        container.close();
        BufferedDataTable outTable = container.getTable();
        return new BufferedDataTable[]{outTable};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec;
        boolean tableConnected = inSpecs[0] != null;
        DataTableSpec dataTableSpec = inSpec = tableConnected ? inSpecs[0] : this.nodeSettings.createDummyInTable().getDataTableSpec();
        if (tableConnected) {
            DataColumnSpec inColSpec = inSpec.getColumnSpec(this.nodeSettings.getInputColumnName());
            if (inColSpec == null) {
                throw new InvalidSettingsException("Please configure an input column.");
            }
            if (!inColSpec.getType().isCompatible(StringValue.class)) {
                throw new InvalidSettingsException(String.format("Column %s is not a StringValue; please reconfigure the node.", this.nodeSettings.getInputColumnName()));
            }
        }
        DataTableSpec outSpec = this.createSpec(inSpec, tableConnected, -1);
        return new DataTableSpec[]{outSpec};
    }

    private DataTableSpec createSpec(DataTableSpec inSpec, boolean tableConnected, int maxMatchCount) throws InvalidSettingsException {
        DataTableSpecCreator specCreator = new DataTableSpecCreator(inSpec);
        String nameOrPrefix = Optional.ofNullable(this.nodeSettings.getOutputColumnNameOrPrefix()).orElse("");
        RegExTractor extractor = this.nodeSettings.createExtractor();
        ArrayList<String> groupNames = new ArrayList<String>(extractor.getGroupNames());
        if (this.nodeSettings.isDropFullMatchColumn()) {
            groupNames.remove("Full Match");
        }
        if (groupNames.isEmpty()) {
            this.setWarningMessage("No result columns will be appended. Either define at least one capturing group, or disable the \u201cNo Full Match\u201d option.");
        }
        switch (this.nodeSettings.getMapping()) {
            case ROWS: 
            case ROWS_OR_MISSING: {
                groupNames.forEach(name -> {
                    DataTableSpecCreator dataTableSpecCreator2 = specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix + name, StringCell.TYPE).createSpec()});
                });
                if (!this.nodeSettings.isAppendInputId()) break;
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix + "RowID", StringCell.TYPE).createSpec()});
                break;
            }
            case SINGLE_ROW: {
                groupNames.forEach(name -> {
                    DataTableSpecCreator dataTableSpecCreator2 = specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix + name, StringCell.TYPE).createSpec()});
                });
                break;
            }
            case COLUMNS: {
                if (!nameOrPrefix.contains(MATCHINDEX_PLACEHOLDER)) {
                    throw new InvalidSettingsException("The \u201cPrefix\u201d must contain a placeholder $MATCHINDEX for the match index");
                }
                if (maxMatchCount == -1) {
                    return null;
                }
                int i = 0;
                while (i < maxMatchCount) {
                    String currentPrefix = nameOrPrefix.replace(MATCHINDEX_PLACEHOLDER, String.valueOf(i));
                    groupNames.forEach(name -> specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(currentPrefix + name, StringCell.TYPE).createSpec()}));
                    ++i;
                }
                break;
            }
            case JSON: {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix, JSONCell.TYPE).createSpec()});
                break;
            }
            case LIST: {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix, ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()});
                break;
            }
            default: {
                throw new InvalidSettingsException("Unimplemented: " + String.valueOf((Object)this.nodeSettings.getMapping()));
            }
        }
        DataTableSpec spec = specCreator.createSpec();
        if (!tableConnected || this.nodeSettings.isDropInputColumn()) {
            String inColName = tableConnected ? this.nodeSettings.getInputColumnName() : "text";
            int inCellIndex = inSpec.findColumnIndex(inColName);
            spec = FilterColumnTable.createFilterTableSpec((DataTableSpec)spec, (boolean)false, (int[])new int[]{inCellIndex});
        }
        return spec;
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        new RegexExtractorNodeSettings().loadSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void reset() {
    }

    private static final class ExecutionContextCharSequence
    implements CharSequence {
        private static final int CHECK_EVERY_NTH_CALL = 100;
        private final CharSequence inner;
        private final ExecutionMonitor exec;
        private long callCount = 0L;

        private ExecutionContextCharSequence(CharSequence inner, ExecutionMonitor exec) {
            this.inner = inner;
            this.exec = exec;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ExecutionContextCharSequence(this.inner.subSequence(start, end), this.exec);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public char charAt(int index) {
            this.checkTimeout();
            return this.inner.charAt(index);
        }

        private void checkTimeout() {
            if (this.callCount++ % 100L != 0L) {
                return;
            }
            try {
                this.exec.checkCanceled();
            }
            catch (CanceledExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toString() {
            return this.inner.toString();
        }
    }
}

