/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.regex2;

import de.philippkatz.regextractor.RegExTractorUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.DataAwareNodeDialogPane;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.util.ColumnSelectionComboxBox;
import ws.palladian.nodes.extraction.regex.RegexExtractorTemplateSettings;
import ws.palladian.nodes.extraction.regex2.RegexExtractor2NodeSettings;

class RegexExtractor2NodeDialog
extends DataAwareNodeDialogPane {
    private static final int NUM_ROWS_TO_KEEP = 25;
    private static final long TIMEOUT_MS = 15000L;
    private final RegexExtractor2NodeSettings nodeSettings = new RegexExtractor2NodeSettings();
    private final RegExTractorUI regExTractorUI;
    private ColumnSelectionComboxBox inputColumnSelection;
    private JCheckBox dropInputCheckBox;
    private JSpinner previewRowSpinner;
    private JComboBox<RegexExtractor2NodeSettings.Mapping> mappingBox;
    private JCheckBox appendRowKeyBox;
    private JLabel outputColumnNameOrPrefixLabel;
    private JTextField outputColumnNameOrPrefixField;
    private DataTableSpec spec;
    private List<DataRow> previewRows;
    private final Mode mode;
    private CardLayout inputCardLayout;
    private JPanel inputCardPanel;
    private JCheckBox dropFullMatchCheckBox;

    RegexExtractor2NodeDialog(Mode mode) {
        this.mode = mode;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel inputOutputOptions = new JPanel(new GridLayout(1, 2, 10, 0));
        inputOutputOptions.add(this.createInputOptions());
        inputOutputOptions.add(this.createOutputOptions());
        panel.add((Component)inputOutputOptions, "North");
        this.regExTractorUI = new RegExTractorUI();
        this.regExTractorUI.setPreferredSize(new Dimension(900, 450));
        this.regExTractorUI.setTextEditable(false);
        this.regExTractorUI.addTemplateListener(() -> RegexExtractorTemplateSettings.save(this.regExTractorUI.getTemplates()));
        this.regExTractorUI.setTimeoutMs(15000L);
        panel.add((Component)this.regExTractorUI, "Center");
        this.addTab("Options", panel, false);
    }

    public void onOpen() {
        this.regExTractorUI.setTemplates(RegexExtractorTemplateSettings.load());
    }

    private Component createInputOptions() {
        JPanel panel = new JPanel(new GridLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Input"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.inputCardLayout = new CardLayout();
        this.inputCardPanel = new JPanel(this.inputCardLayout);
        panel.add(this.inputCardPanel);
        JPanel gridBagPanel = new JPanel(new GridBagLayout());
        this.inputColumnSelection = new ColumnSelectionComboxBox(null, new Class[]{StringValue.class});
        this.inputColumnSelection.addItemListener(e -> this.updatePreview());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        gridBagPanel.add((Component)this.inputColumnSelection, c);
        this.dropInputCheckBox = new JCheckBox("Drop column");
        ++c.gridx;
        gridBagPanel.add((Component)this.dropInputCheckBox, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        gridBagPanel.add((Component)new JLabel("    "), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        gridBagPanel.add((Component)new JLabel("Preview row:"), c);
        this.previewRowSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        this.previewRowSpinner.addChangeListener(e -> this.updatePreview());
        ++c.gridx;
        gridBagPanel.add((Component)this.previewRowSpinner, c);
        this.inputCardPanel.add(Mode.TABLE_INPUT.toString(), gridBagPanel);
        this.inputCardPanel.add(Mode.TEXT_INPUT.toString(), new JLabel("No input table connected \u2013 enter some text below."));
        return panel;
    }

    private Component createOutputOptions() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Output"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.mappingBox = new JComboBox<RegexExtractor2NodeSettings.Mapping>(RegexExtractor2NodeSettings.Mapping.values());
        this.mappingBox.addItemListener(e -> this.toggleOutputOptions(true));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        panel.add(this.mappingBox, c);
        ++c.gridx;
        panel.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.outputColumnNameOrPrefixLabel = new JLabel("Prefix: ");
        panel.add((Component)this.outputColumnNameOrPrefixLabel, c);
        this.outputColumnNameOrPrefixField = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.outputColumnNameOrPrefixField, c);
        this.appendRowKeyBox = new JCheckBox("RowID");
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)this.appendRowKeyBox, c);
        this.dropFullMatchCheckBox = new JCheckBox("No Full Match");
        ++c.gridx;
        panel.add(this.dropFullMatchCheckBox);
        return panel;
    }

    private void toggleOutputOptions(boolean resetNameOrPrefixField) {
        boolean showName = EnumSet.of(RegexExtractor2NodeSettings.Mapping.JSON, RegexExtractor2NodeSettings.Mapping.LIST, RegexExtractor2NodeSettings.Mapping.IS_MATCH, RegexExtractor2NodeSettings.Mapping.MATCH_COUNT).contains(this.mappingBox.getSelectedItem());
        this.outputColumnNameOrPrefixLabel.setText(showName ? "Name: " : "Prefix: ");
        if (resetNameOrPrefixField) {
            if (showName) {
                this.outputColumnNameOrPrefixField.setText("Matches for " + this.inputColumnSelection.getSelectedColumn());
            } else if (RegexExtractor2NodeSettings.Mapping.COLUMNS.equals(this.mappingBox.getSelectedItem())) {
                this.outputColumnNameOrPrefixField.setText("Match $MATCHINDEX: ");
            } else {
                this.outputColumnNameOrPrefixField.setText("");
            }
        }
        boolean showAppendKeyRow = EnumSet.of(RegexExtractor2NodeSettings.Mapping.ROWS, RegexExtractor2NodeSettings.Mapping.ROWS_OR_MISSING).contains(this.mappingBox.getSelectedItem()) && this.mode == Mode.TABLE_INPUT;
        this.appendRowKeyBox.setVisible(showAppendKeyRow);
        boolean showDropFullMatch = EnumSet.of(RegexExtractor2NodeSettings.Mapping.ROWS, RegexExtractor2NodeSettings.Mapping.ROWS_OR_MISSING, RegexExtractor2NodeSettings.Mapping.SINGLE_ROW, RegexExtractor2NodeSettings.Mapping.COLUMNS, RegexExtractor2NodeSettings.Mapping.LIST).contains(this.mappingBox.getSelectedItem());
        this.dropFullMatchCheckBox.setVisible(showDropFullMatch);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        if (this.mode == Mode.TEXT_INPUT) {
            this.nodeSettings.loadSettings(settings);
            DataTable inTable = this.nodeSettings.createDummyInTable();
            this.internalLoadSettings(settings, inTable.getDataTableSpec(), inTable);
        } else {
            this.internalLoadSettings(settings, (DataTableSpec)specs[0], null);
        }
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, BufferedDataTable[] input) throws NotConfigurableException {
        this.internalLoadSettings(settings, input[0].getSpec(), (DataTable)input[0]);
    }

    private void internalLoadSettings(NodeSettingsRO settings, DataTableSpec inSpec, DataTable inTable) throws NotConfigurableException {
        this.regExTractorUI.setTextEditable(this.mode == Mode.TEXT_INPUT);
        this.inputCardLayout.show(this.inputCardPanel, this.mode.toString());
        this.nodeSettings.loadSettings(settings);
        this.inputColumnSelection.update(inSpec, this.nodeSettings.getInputColumnName());
        this.dropInputCheckBox.setSelected(this.nodeSettings.isDropInputColumn());
        this.mappingBox.setSelectedItem((Object)this.nodeSettings.getMapping());
        this.outputColumnNameOrPrefixField.setText(this.nodeSettings.getOutputColumnNameOrPrefix());
        this.appendRowKeyBox.setSelected(this.nodeSettings.isAppendInputId());
        if (this.mode == Mode.TEXT_INPUT) {
            this.regExTractorUI.setText(this.nodeSettings.getText());
        } else {
            this.regExTractorUI.setText("");
        }
        this.regExTractorUI.setRegex(this.nodeSettings.getPattern());
        this.regExTractorUI.setFlags(this.nodeSettings.getFlags());
        if (inTable != null) {
            this.regExTractorUI.hideTextOverlay();
            this.spec = inTable.getDataTableSpec();
            this.previewRows = StreamSupport.stream(inTable.spliterator(), false).limit(25L).collect(Collectors.toList());
            ((SpinnerNumberModel)this.previewRowSpinner.getModel()).setMaximum(Integer.valueOf(this.previewRows.size()));
            this.updatePreview();
        } else {
            String message = "<html><div style='text-align:center'><h2>Data not available</h2><p>To show the text, make sure that the upstream node<br>has executed and reopen the dialog. Alternatively, go<br>to the KNIME preferences \u2192 \u201cKNIME GUI\u201d and set the option<br>\u201cExecute upstream nodes when needed\u201d to \u201cAlways\u201d.</p></div></html>";
            this.regExTractorUI.showTextOverlay(message);
        }
        this.previewRowSpinner.setEnabled(inTable != null);
        this.dropFullMatchCheckBox.setSelected(this.nodeSettings.isDropFullMatchColumn());
        this.toggleOutputOptions(false);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.setInputColumnName(this.inputColumnSelection.getSelectedColumn());
        this.nodeSettings.setDropInputColumn(this.dropInputCheckBox.isSelected());
        this.nodeSettings.setMapping((RegexExtractor2NodeSettings.Mapping)((Object)this.mappingBox.getSelectedItem()));
        this.nodeSettings.setOutputColumnNameOrPrefix(this.outputColumnNameOrPrefixField.getText());
        this.nodeSettings.setAppendInputId(this.appendRowKeyBox.isSelected());
        this.nodeSettings.setText(this.regExTractorUI.getText());
        this.nodeSettings.setPattern(this.regExTractorUI.getRegex());
        this.nodeSettings.setFlags(this.regExTractorUI.getFlags());
        this.nodeSettings.setDropFullMatchColumn(this.dropFullMatchCheckBox.isSelected());
        this.nodeSettings.saveSettings(settings);
    }

    private void updatePreview() {
        if (this.spec == null || this.previewRows == null) {
            return;
        }
        int cellIndex = this.spec.findColumnIndex(this.inputColumnSelection.getSelectedColumn());
        if (cellIndex < 0) {
            return;
        }
        int rowNumber = (Integer)this.previewRowSpinner.getValue() - 1;
        if (rowNumber >= this.previewRows.size()) {
            return;
        }
        DataCell cell = this.previewRows.get(rowNumber).getCell(cellIndex);
        String text = cell.isMissing() ? "" : ((StringValue)cell).getStringValue();
        this.regExTractorUI.setText(text);
    }

    public boolean closeOnESC() {
        return false;
    }

    static enum Mode {
        TABLE_INPUT,
        TEXT_INPUT;

    }
}

