/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.regex2;

import de.philippkatz.regextractor.RegExTractor;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.container.DataContainer;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class RegexExtractor2NodeSettings {
    static final String DUMMY_INPUT_COLUMN_NAME = "text";
    private static final String KEY_INPUT_COLUMN_NAME = "inputColumnName";
    private static final String KEY_DROP_INPUT_COLUMN = "dropInputColumn";
    private static final String KEY_MAPPING = "mapping";
    private static final String KEY_OUTPUT_COLUMN_NAME_OR_PREFIX = "outputColumnNameOrPrefix";
    private static final String KEY_APPEND_INPUT_ID = "appendInputId";
    private static final String KEY_TEXT = "text";
    private static final String KEY_PATTERN = "pattern";
    private static final String KEY_FLAGS = "flags";
    private static final String KEY_DROP_FULL_MATCH_COLUMN = "dropFullMatchColumn";
    private static final String EMPTY = "";
    private static final int FLAGS_DEFAULT = 0;
    private static final Mapping MAPPING_DEFAULT = Mapping.ROWS;
    private String inputColumnName;
    private boolean dropInputColumn;
    private Mapping mapping = MAPPING_DEFAULT;
    private String outputColumnNameOrPrefix;
    private boolean appendInputId;
    private String text = "";
    private String pattern = "";
    private int flags = 0;
    private boolean dropFullMatchColumn;

    RegexExtractor2NodeSettings() {
    }

    public String getInputColumnName() {
        return this.inputColumnName;
    }

    public void setInputColumnName(String inputColumnName) {
        this.inputColumnName = inputColumnName;
    }

    public boolean isDropInputColumn() {
        return this.dropInputColumn;
    }

    public void setDropInputColumn(boolean dropInputColumn) {
        this.dropInputColumn = dropInputColumn;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public String getOutputColumnNameOrPrefix() {
        return this.outputColumnNameOrPrefix;
    }

    public void setOutputColumnNameOrPrefix(String outputColumnNameOrPrefix) {
        this.outputColumnNameOrPrefix = outputColumnNameOrPrefix;
    }

    public boolean isAppendInputId() {
        return this.appendInputId;
    }

    public void setAppendInputId(boolean appendInputId) {
        this.appendInputId = appendInputId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isDropFullMatchColumn() {
        return this.dropFullMatchColumn;
    }

    public void setDropFullMatchColumn(boolean dropFullMatchColumn) {
        this.dropFullMatchColumn = dropFullMatchColumn;
    }

    public void loadSettings(NodeSettingsRO settings) {
        this.inputColumnName = settings.getString(KEY_INPUT_COLUMN_NAME, null);
        this.dropInputColumn = settings.getBoolean(KEY_DROP_INPUT_COLUMN, false);
        this.mapping = Mapping.valueOf(settings.getString(KEY_MAPPING, MAPPING_DEFAULT.name()));
        this.outputColumnNameOrPrefix = settings.getString(KEY_OUTPUT_COLUMN_NAME_OR_PREFIX, null);
        this.appendInputId = settings.getBoolean(KEY_APPEND_INPUT_ID, false);
        this.text = settings.getString("text", null);
        this.pattern = settings.getString(KEY_PATTERN, EMPTY);
        this.flags = settings.getInt(KEY_FLAGS, 0);
        this.dropFullMatchColumn = settings.getBoolean(KEY_DROP_FULL_MATCH_COLUMN, false);
    }

    public void saveSettings(NodeSettingsWO settings) {
        settings.addString(KEY_INPUT_COLUMN_NAME, this.inputColumnName);
        settings.addBoolean(KEY_DROP_INPUT_COLUMN, this.dropInputColumn);
        settings.addString(KEY_MAPPING, this.mapping.name());
        settings.addString(KEY_OUTPUT_COLUMN_NAME_OR_PREFIX, this.outputColumnNameOrPrefix);
        settings.addBoolean(KEY_APPEND_INPUT_ID, this.appendInputId);
        settings.addString("text", this.text);
        settings.addString(KEY_PATTERN, this.pattern);
        settings.addInt(KEY_FLAGS, this.flags);
        settings.addBoolean(KEY_DROP_FULL_MATCH_COLUMN, this.dropFullMatchColumn);
    }

    public RegExTractor createExtractor() {
        return new RegExTractor(this.getPattern(), this.getFlags());
    }

    public DataTable createDummyInTable() {
        DataTableSpec spec = new DataTableSpecCreator().addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("text", StringCell.TYPE).createSpec()}).createSpec();
        DataContainer container = new DataContainer(spec);
        DataCell cell = this.getText() != null ? new StringCell(this.getText()) : DataType.getMissingCell();
        container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)0L), new DataCell[]{cell}));
        container.close();
        return container.getTable();
    }

    static enum Mapping {
        ROWS("Rows"),
        ROWS_OR_MISSING("Rows or Missing"),
        SINGLE_ROW("Single Row"),
        COLUMNS("Columns"),
        JSON("JSON"),
        LIST("List"),
        IS_MATCH("Is Match (Boolean)"),
        MATCH_COUNT("Match Count (Number)");

        private final String label;

        private Mapping(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

