/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.geo.geohash.creator;

import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.MissingCell;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.helper.geo.GeoUtils;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;
import ws.palladian.nodes.geo.geohash.creator.GeohashCreatorSettings;

class GeohashCreatorNodeModel
extends SimpleStreamableFunctionNodeModel {
    private final GeohashCreatorSettings nodeSettings = new GeohashCreatorSettings();

    GeohashCreatorNodeModel() {
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        final int inColIdx = spec.findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
        Object appendedColumnName = this.nodeSettings.outputColumn.getStringValue();
        if (StringUtils.nullOrEmpty((String)appendedColumnName)) {
            appendedColumnName = this.nodeSettings.inputColumn.getStringValue() + " (geohash)";
        }
        DataColumnSpec colSpec = new DataColumnSpecCreator((String)appendedColumnName, StringCell.TYPE).createSpec();
        SingleCellFactory cellFactory = new SingleCellFactory(colSpec){

            public DataCell getCell(DataRow row) {
                DataCell cell = row.getCell(inColIdx);
                if (cell.isMissing()) {
                    return DataType.getMissingCell();
                }
                GeoCoordinateValue coordinateValue = (GeoCoordinateValue)cell;
                try {
                    String geohash = GeoUtils.getGeohash((GeoCoordinate)coordinateValue, (int)GeohashCreatorNodeModel.this.nodeSettings.hashLength.getIntValue());
                    return new StringCell(geohash);
                }
                catch (IllegalArgumentException e) {
                    return new MissingCell(e.getMessage());
                }
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)cellFactory);
        if (this.nodeSettings.dropInputColumn.getBooleanValue()) {
            rearranger.remove(new int[]{inColIdx});
        }
        return rearranger;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        int inputColIdx = inSpecs[0].findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
        if (inputColIdx < 0) {
            throw new InvalidSettingsException("Please select a valid input column.");
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }
}

