/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.geo.mapviewer2;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jxmapviewer.viewer.TileFactoryInfo;

public final class CustomTileFactoryInfo
extends TileFactoryInfo {
    public static final String NAME = "Custom Tile Server";
    private static final String PLACEHOLDER_ZOOM = "{zoom}";
    private static final String PLACEHOLDER_X = "{x}";
    private static final String PLACEHOLDER_Y = "{y}";
    private final String urlTemplate;

    public CustomTileFactoryInfo(String urlTemplate, int minimumZoomLevel, int maximumZoomLevel) {
        super(minimumZoomLevel, maximumZoomLevel, maximumZoomLevel - minimumZoomLevel, 256, true, true, null, null, null, null);
        if (urlTemplate == null || urlTemplate.isEmpty()) {
            throw new IllegalArgumentException("No URL specified");
        }
        CustomTileFactoryInfo.checkPlaceholder(urlTemplate, PLACEHOLDER_ZOOM);
        CustomTileFactoryInfo.checkPlaceholder(urlTemplate, PLACEHOLDER_X);
        CustomTileFactoryInfo.checkPlaceholder(urlTemplate, PLACEHOLDER_Y);
        CustomTileFactoryInfo.checkUrl(urlTemplate);
        this.urlTemplate = urlTemplate;
    }

    public String getTileUrl(int x, int y, int zoom) {
        int z = this.getMaximumZoomLevel() - zoom;
        return CustomTileFactoryInfo.replacePlaceholders(this.urlTemplate, x, y, z);
    }

    public String getName() {
        return NAME;
    }

    private static void checkUrl(String url) {
        try {
            new URI(CustomTileFactoryInfo.replacePlaceholders(url, 0, 0, 0)).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
            throw new IllegalArgumentException(String.format("Invalid URL: %s", url));
        }
    }

    private static void checkPlaceholder(String urlTemplate, String placeholder) {
        if (!urlTemplate.contains(placeholder)) {
            throw new IllegalArgumentException(String.format("Placeholder %s is missing in URL", placeholder));
        }
    }

    private static String replacePlaceholders(String urlTemplate, int x, int y, int z) {
        return urlTemplate.replace(PLACEHOLDER_ZOOM, String.valueOf(z)).replace(PLACEHOLDER_X, String.valueOf(x)).replace(PLACEHOLDER_Y, String.valueOf(y));
    }
}

