/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.geo.mapviewer2;

import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;
import ws.palladian.nodes.extraction.location.waypointrenderer.InfoWaypointRenderer;
import ws.palladian.nodes.geo.mapviewer2.MapViewer2NodeSettings;
import ws.palladian.nodes.geo.mapviewer2.TileTester;

class MapViewer2NodeDialog
extends DefaultNodeSettingsPane {
    private final MapViewer2NodeSettings nodeSettings = new MapViewer2NodeSettings();
    private DialogComponentButton testRequestButton;

    protected MapViewer2NodeDialog() {
        this.setDefaultTabTitle("General");
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.nodeSettings.inputColumn, "Coordinates", 0, new Class[]{GeoCoordinateValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.nodeSettings.labelColumn, "Label", 0, false, true, new Class[]{StringValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(this.nodeSettings.renderer, "Renderer", MapViewer2NodeSettings.RENDERERS.stream().map(InfoWaypointRenderer::getName).toList()));
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(this.nodeSettings.tileProvider, "Tile Provider", this.nodeSettings.getTileInfos().stream().map(MapViewer2NodeSettings.TileInfo::getName).toList()));
        this.setHorizontalPlacement(true);
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.nodeSettings.width, "Image Width", (Number)100));
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.nodeSettings.height, "Image Height", (Number)100));
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.nodeSettings.initialZoomLevel, "Initial Zoom Level", (Number)1));
        this.createNewTab("Custom Tile Server");
        this.setHorizontalPlacement(false);
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.nodeSettings.urlTemplate, "URL Template", false, 40));
        this.setHorizontalPlacement(true);
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.nodeSettings.minZoomLevel, "Min. Zoom Level", (Number)1));
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.nodeSettings.maxZoomLevel, "Max. Zoom Level", (Number)1));
        this.setHorizontalPlacement(false);
        this.testRequestButton = new DialogComponentButton("Test Request");
        this.testRequestButton.addActionListener(e -> this.performTestRequest());
        this.addDialogComponent((DialogComponent)this.testRequestButton);
    }

    private void performTestRequest() {
        final JButton button = (JButton)this.testRequestButton.getComponentPanel().getComponent(0);
        button.setEnabled(false);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                MapViewer2NodeSettings.TileInfo tileInfo = MapViewer2NodeDialog.this.nodeSettings.getTileInfos().stream().filter(f -> f.getName().equals("Custom Tile Server")).findFirst().orElseThrow();
                TileTester.testTileLoading(tileInfo.getFactory());
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        JOptionPane.showMessageDialog(MapViewer2NodeDialog.this.getPanel(), "Test request successful.");
                    }
                    catch (InterruptedException | ExecutionException e) {
                        JOptionPane.showMessageDialog(MapViewer2NodeDialog.this.getPanel(), String.format("Test request failed: %s", e.getCause().getMessage()), "Error", 0);
                        button.setEnabled(true);
                    }
                }
                finally {
                    button.setEnabled(true);
                }
            }
        };
        worker.execute();
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        MapViewer2NodeSettings.TileInfo tileInfo = this.nodeSettings.getTileInfo();
        tileInfo.validate();
        int initialZoomLevel = this.nodeSettings.initialZoomLevel.getIntValue();
        int maxSupportedZoomLevel = tileInfo.getFactory().getMaximumZoomLevel();
        if (initialZoomLevel > maxSupportedZoomLevel) {
            throw new InvalidSettingsException(String.format("Maximum initial zoom level for %s is %d", tileInfo.getName(), maxSupportedZoomLevel));
        }
    }
}

