/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.geo.mapviewer2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.extraction.location.tiles.AppleTileFactoryInfo;
import ws.palladian.nodes.extraction.location.tiles.VirtualEarthTileFactoryInfo;
import ws.palladian.nodes.extraction.location.tiles.WikimediaMaps;
import ws.palladian.nodes.extraction.location.waypointrenderer.CircleWaypointRenderer;
import ws.palladian.nodes.extraction.location.waypointrenderer.DropWaypointRenderer;
import ws.palladian.nodes.extraction.location.waypointrenderer.InfoWaypointRenderer;
import ws.palladian.nodes.extraction.location.waypointrenderer.LabelWaypointRenderer;
import ws.palladian.nodes.geo.mapviewer2.CustomTileFactoryInfo;
import ws.palladian.nodes.geo.mapviewer2.OSMTileFactoryInfoFixed;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class MapViewer2NodeSettings {
    private static final InfoWaypointRenderer DEFAULT_RENDERER = new DropWaypointRenderer();
    private static final TileInfo DEFAULT_TILE_FACTORY = new DefaultTileInfo(OSMTileFactoryInfoFixed.INSTANCE);
    static final Set<InfoWaypointRenderer> RENDERERS = new LinkedHashSet<InfoWaypointRenderer>();
    private static final List<TileInfo> TILE_INFOS = new ArrayList<TileInfo>();
    private static final String CFGKEY_INPUT_COORDINATE_NAME = "settingCoordinateInputColumn";
    private static final String CFGKEY_INPUT_LABEL = "settingLabelInputColumn";
    final SettingsModelString inputColumn = new SettingsModelString("settingCoordinateInputColumn", null);
    final SettingsModelString labelColumn = new SettingsModelString("settingLabelInputColumn", null);
    final SettingsModelString renderer = new SettingsModelString("renderer", DEFAULT_RENDERER.getName());
    final SettingsModelString tileProvider = new SettingsModelString("tileProvider", DEFAULT_TILE_FACTORY.getName());
    final SettingsModelIntegerBounded width = new SettingsModelIntegerBounded("width", 500, 50, 5000);
    final SettingsModelIntegerBounded height = new SettingsModelIntegerBounded("height", 500, 50, 5000);
    final SettingsModelString urlTemplate = new SettingsModelString("customTileServerUrlTemplate", null);
    final SettingsModelInteger minZoomLevel = new SettingsModelIntegerBounded("customTileServerMinZoomLevel", 0, 0, 25);
    final SettingsModelInteger maxZoomLevel = new SettingsModelIntegerBounded("customTileServerMaxZoomLevel", 19, 0, 25);
    final SettingsModelInteger initialZoomLevel = new SettingsModelIntegerBounded("initialZoomLevel", -1, -1, 25);

    static {
        RENDERERS.add(DEFAULT_RENDERER);
        RENDERERS.add(new LabelWaypointRenderer());
        RENDERERS.add(new CircleWaypointRenderer());
        TILE_INFOS.add(DEFAULT_TILE_FACTORY);
        TILE_INFOS.add(new DefaultTileInfo(AppleTileFactoryInfo.APPLE));
        TILE_INFOS.add(new DefaultTileInfo((TileFactoryInfo)new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.MAP)));
        TILE_INFOS.add(new DefaultTileInfo((TileFactoryInfo)new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.SATELLITE)));
        TILE_INFOS.add(new DefaultTileInfo((TileFactoryInfo)new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.HYBRID)));
        TILE_INFOS.add(new DefaultTileInfo(WikimediaMaps.INSTANCE));
    }

    MapViewer2NodeSettings() {
    }

    void saveSettings(NodeSettingsWO settings) {
        this.inputColumn.saveSettingsTo(settings);
        this.labelColumn.saveSettingsTo(settings);
        this.renderer.saveSettingsTo(settings);
        this.tileProvider.saveSettingsTo(settings);
        this.width.saveSettingsTo(settings);
        this.height.saveSettingsTo(settings);
        this.urlTemplate.saveSettingsTo(settings);
        this.minZoomLevel.saveSettingsTo(settings);
        this.maxZoomLevel.saveSettingsTo(settings);
        this.initialZoomLevel.saveSettingsTo(settings);
    }

    void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumn.loadSettingsFrom(settings);
        this.labelColumn.loadSettingsFrom(settings);
        this.renderer.loadSettingsFrom(settings);
        this.tileProvider.loadSettingsFrom(settings);
        this.width.loadSettingsFrom(settings);
        this.height.loadSettingsFrom(settings);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.urlTemplate);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.minZoomLevel);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.maxZoomLevel);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.initialZoomLevel);
    }

    void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumn.validateSettings(settings);
        this.labelColumn.validateSettings(settings);
        this.renderer.validateSettings(settings);
        this.tileProvider.validateSettings(settings);
        this.width.validateSettings(settings);
        this.height.validateSettings(settings);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.urlTemplate);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.minZoomLevel);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.maxZoomLevel);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.initialZoomLevel);
    }

    TileInfo getTileInfo() {
        return this.getTileInfos().stream().filter(f -> f.getName().equals(this.tileProvider.getStringValue())).findFirst().orElse(DEFAULT_TILE_FACTORY);
    }

    InfoWaypointRenderer getRenderer() {
        return RENDERERS.stream().filter(r -> r.getName().equals(this.renderer.getStringValue())).findFirst().orElse(DEFAULT_RENDERER);
    }

    List<TileInfo> getTileInfos() {
        ArrayList<TileInfo> tileInfos = new ArrayList<TileInfo>(TILE_INFOS);
        tileInfos.add(new TileInfo(){

            @Override
            public String getName() {
                return "Custom Tile Server";
            }

            @Override
            public TileFactoryInfo getFactory() {
                return new CustomTileFactoryInfo(MapViewer2NodeSettings.this.urlTemplate.getStringValue(), MapViewer2NodeSettings.this.minZoomLevel.getIntValue(), MapViewer2NodeSettings.this.maxZoomLevel.getIntValue());
            }

            @Override
            public boolean isEnabled() {
                try {
                    this.validate();
                    return true;
                }
                catch (InvalidSettingsException invalidSettingsException) {
                    return false;
                }
            }

            @Override
            public void validate() throws InvalidSettingsException {
                try {
                    this.getFactory();
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidSettingsException(e.getMessage());
                }
            }
        });
        Collections.sort(tileInfos, Comparator.comparing(TileInfo::getName));
        return Collections.unmodifiableList(tileInfos);
    }

    private static final class DefaultTileInfo
    implements TileInfo {
        private final TileFactoryInfo factory;

        DefaultTileInfo(TileFactoryInfo factory) {
            this.factory = factory;
        }

        @Override
        public String getName() {
            return this.factory.getName();
        }

        @Override
        public TileFactoryInfo getFactory() {
            return this.factory;
        }
    }

    static interface TileInfo {
        public String getName();

        public TileFactoryInfo getFactory();

        default public boolean isEnabled() {
            return true;
        }

        default public void validate() throws InvalidSettingsException {
        }
    }
}

